package rearth.oritech.block.entity.addons;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.client.ui.RedstoneAddonScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class RedstoneAddonBlockEntity extends AddonBlockEntity implements class_5558<RedstoneAddonBlockEntity>, ExtendedMenuProvider, ComparatorOutputProvider {
    
    private RedstoneControllable cachedController;
    public RedstoneMode activeMode = RedstoneMode.INPUT_CONTROL;
    public int monitoredSlot = 0;
    
    public int currentOutput;
    
    public RedstoneAddonBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REDSTONE_ADDON_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, RedstoneAddonBlockEntity blockEntity) {
        if (world.field_9236 || !isConnected() || activeMode == RedstoneMode.INPUT_CONTROL) return;
        
        var lastOutput = currentOutput;
        
        switch (activeMode) {
            case OUTPUT_POWER -> currentOutput = cachedController.getComparatorEnergyAmount();
            case OUTPUT_SLOT -> currentOutput = cachedController.getComparatorSlotAmount(monitoredSlot);
            case OUTPUT_PROGRESS -> currentOutput = cachedController.getComparatorProgress();
            case OUTPUT_ACTIVE -> currentOutput = cachedController.getComparatorActiveState();
            case INPUT_CONTROL -> currentOutput = 0;
        }
        
        if (currentOutput != lastOutput) {
            this.method_5431();
        }
        
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("slot", monitoredSlot);
        nbt.method_10569("mode", activeMode.ordinal());
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        monitoredSlot = nbt.method_10550("slot");
        activeMode = RedstoneMode.values()[nbt.method_10550("mode")];
    }
    
    public void sendDataToClient() {
        NetworkManager.sendBlockHandle(this, new RedstoneAddonClientUpdate(field_11867, getControllerPos(), monitoredSlot, activeMode.ordinal(), currentOutput));
    }
    
    public void sendDataToServer() {
        NetworkManager.sendToServer(new RedstoneAddonServerUpdate(field_11867, getControllerPos(), monitoredSlot, activeMode.ordinal(), currentOutput));
    }
    
    private boolean isConnected() {
        var isUsed = this.method_11010().method_11654(MachineAddonBlock.ADDON_USED);
        return isUsed && getCachedController() != null;
    }
    
    public RedstoneControllable getCachedController() {
        
        if (cachedController != null)
            return cachedController;
        
        if (field_11863.method_8321(getControllerPos()) instanceof RedstoneControllable redstoneControllable) {
            cachedController = redstoneControllable;
        }
        
        return cachedController;
    }
    
    public void setRedstonePowered(boolean isPowered) {
        this.method_5431();
        
        if (activeMode != RedstoneMode.INPUT_CONTROL) return;
        
        if (getCachedController() != null)
            cachedController.onRedstoneEvent(isPowered);
        
    }

    @Override
    public int getComparatorOutput() {
        return currentOutput;
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendDataToClient();
        buf.method_10807(field_11867);
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new RedstoneAddonScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470("");
    }
    
    public static void receiveOnServer(RedstoneAddonServerUpdate message, class_1657 player, class_5455 dynamicRegistryManager) {
        if (player.method_37908().method_8321(message.position) instanceof RedstoneAddonBlockEntity addonEntity) {
            addonEntity.activeMode = RedstoneMode.values()[message.targetMode()];
            addonEntity.monitoredSlot = message.targetSlot();
        }
    }
    
    public static void receiveOnClient(RedstoneAddonClientUpdate message, class_1937 world, class_5455 dynamicRegistryManager) {
        if (world.method_8321(message.position) instanceof RedstoneAddonBlockEntity addonEntity) {
            addonEntity.currentOutput = message.currentOutput();
            addonEntity.activeMode = RedstoneMode.values()[message.targetMode()];
            addonEntity.monitoredSlot = message.targetSlot();
            addonEntity.setControllerPos(message.controllerPos());
        }
    }
    
    public enum RedstoneMode {
        OUTPUT_POWER, OUTPUT_SLOT, OUTPUT_PROGRESS, OUTPUT_ACTIVE, INPUT_CONTROL
    }
    
    public interface RedstoneControllable extends ComparatorOutputProvider {
        int getComparatorEnergyAmount();
        int getComparatorSlotAmount(int slot);
        int getComparatorProgress();
        int getComparatorActiveState();
        void onRedstoneEvent(boolean isPowered);

        /**
         * A redstone controllable machine only outputs a readable comparator signal from the controller addon block.
         * @return 0
         */
        @Override
        default int getComparatorOutput() {
            return 0;
        }
    }
    
    // we need 2 here because Neoforge is annoying as always and doesnt let me register it in both directions
    public record RedstoneAddonClientUpdate(class_2338 position, class_2338 controllerPos, int targetSlot, int targetMode, int currentOutput) implements class_8710 {
        
        public static final class_8710.class_9154<RedstoneAddonClientUpdate> PACKET_ID = new class_8710.class_9154<>(Oritech.id("redstoneaddonclient"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
    
    public record RedstoneAddonServerUpdate(class_2338 position, class_2338 controllerPos, int targetSlot, int targetMode, int currentOutput) implements class_8710 {
        
        public static final class_8710.class_9154<RedstoneAddonServerUpdate> PACKET_ID = new class_8710.class_9154<>(Oritech.id("redstoneaddonserver"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}
