package rearth.oritech.block.blocks.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.entity.storage.SmallStorageBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.MachineAddonController;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_8567;

import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public class SmallStorageBlock extends class_2248 implements class_2343 {
    
    public static final class_2753 TARGET_DIR = class_2753.method_35305("target_dir");
    
    public SmallStorageBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(TARGET_DIR, class_2350.field_11043));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(TARGET_DIR);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(TARGET_DIR, ctx.method_7715().method_10153());
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SmallStorageBlockEntity(pos, state);
    }

    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }
    
    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return ((ComparatorOutputProvider) world.method_8321(pos)).getComparatorOutput();
    }
    
    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }
    
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        
        if (world.field_9236) return;
        
        var isPowered = world.method_49803(pos);
        
        var storageEntity = (ExpandableEnergyStorageBlockEntity) world.method_8321(pos);
        storageEntity.setRedstonePowered(isPowered);
        
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof MachineAddonController machineEntity)) {
                return class_1269.field_5812;
            }
            
            machineEntity.initAddons();
            
            var handler = (ExtendedMenuProvider) world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222) player, handler);
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        var droppedStacks = super.method_9560(state, builder);

        var blockEntity = builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof SmallStorageBlockEntity storageEntity) {
            droppedStacks.addAll(storageEntity.inventory.getHeldStacks());
            storageEntity.inventory.method_5448();
        }

        return droppedStacks;
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return getStackWithData(world, pos);
    }
    
    @NotNull
    private static class_1799 getStackWithData(class_4538 world, class_2338 pos) {
        var stack = new class_1799(BlockContent.SMALL_STORAGE_BLOCK.method_8389());
        
        var storageEntity = (SmallStorageBlockEntity) world.method_8321(pos);
        if (storageEntity.getEnergyStorage(null).getAmount() > 0) {
            stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), storageEntity.getEnergyStorage(null).getAmount());
        }
        
        return stack;
    }
    
    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        
        var storedEnergyInStack = itemStack.method_57825(EnergyApi.ITEM.getEnergyComponent(), 0L);
        
        if (storedEnergyInStack > 0) {
            var storageEntity = (ExpandableEnergyStorageBlockEntity) world.method_8321(pos);
            storageEntity.energyStorage.setAmount(storedEnergyInStack);
        }
        
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.field_9236) {
            var entity = world.method_8321(pos);
            if (entity instanceof MachineAddonController machineEntity) {
                machineEntity.resetAddons();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        
        addMachineTooltip(tooltip, this, this);
    }
    
}
