package rearth.oritech.block.blocks.arcane;

import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;

public class SpawnerCageBlock extends class_2248 {
    
    public static class_2746 UP = class_2746.method_11825("up");
    public static class_2746 DOWN = class_2746.method_11825("down");
    public static class_2746 NORTH = class_2746.method_11825("north");
    public static class_2746 EAST = class_2746.method_11825("east");
    public static class_2746 SOUTH = class_2746.method_11825("south");
    public static class_2746 WEST = class_2746.method_11825("west");
    
    public SpawnerCageBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(UP, false).method_11657(DOWN, false).method_11657(NORTH, false).method_11657(EAST, false).method_11657(SOUTH, false).method_11657(WEST,false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(UP, DOWN, NORTH, EAST, SOUTH, WEST);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        var world = ctx.method_8045();
        var pos = ctx.method_8037();
        return getTargetState(world, pos);
    }
    
    private class_2680 getTargetState(class_1936 world, class_2338 pos) {
        
        var state = method_9564();
        
        if (world.method_8320(pos.method_10084()).method_27852(this.method_26160()))
            state = state.method_11657(UP, true);
        if (world.method_8320(pos.method_10074()).method_27852(this.method_26160()))
            state = state.method_11657(DOWN, true);
        if (world.method_8320(pos.method_10095()).method_27852(this.method_26160()))
            state = state.method_11657(NORTH, true);
        if (world.method_8320(pos.method_10078()).method_27852(this.method_26160()))
            state = state.method_11657(EAST, true);
        if (world.method_8320(pos.method_10072()).method_27852(this.method_26160()))
            state = state.method_11657(SOUTH, true);
        if (world.method_8320(pos.method_10067()).method_27852(this.method_26160()))
            state = state.method_11657(WEST, true);
        
        return state;
    }
    
    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return getTargetState(world, pos);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add(class_2561.method_43471("tooltip.oritech.spawner_cage").method_27692(class_124.field_1080));
    }
}
