package rearth.oritech.block.behavior;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.EnergyApi.EnergyStorage;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.TagContent;

public class LaserArmBlockBehavior {
    static private LaserArmBlockBehavior noop;
    static private LaserArmBlockBehavior transferPowerBehavior;
    static private LaserArmBlockBehavior energizeBuddingBehavior;
    
    /**
     * Perform laser behavior on block
     */
    public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (laserEntity.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(blockState))
            return false;
        
        // has an energy storage, try to transfer power to it
        var storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, blockEntity, null);
        // if the storage is not exposed (e.g. catalyst / deep drill / atomic forge), get it directly
        if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider provider)
            storageCandidate = provider.getEnergyStorage(null);
        if (storageCandidate != null)
            return transferPowerBehavior.fireAtBlock(world, laserEntity, block, blockPos, blockState, blockEntity);
        
        // an unregistered budding block, attempt to energize it
        if (blockState.method_26164(TagContent.LASER_ACCELERATED))
            return energizeBuddingBehavior.fireAtBlock(world, laserEntity, block, blockPos, blockState, blockEntity);
        
        // passes through, stop targetting this block
        if (blockState.method_26164(TagContent.LASER_PASSTHROUGH))
            return false;
        
        laserEntity.addBlockBreakProgress(laserEntity.energyRequiredToFire());
        if (laserEntity.getBlockBreakProgress() >= laserEntity.getTargetBlockEnergyNeeded())
            laserEntity.finishBlockBreaking(blockPos, blockState);
        return true;
    }
    
    public static void registerDefaults() {
        noop = new LaserArmBlockBehavior() {
            @Override
            public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
                // don't do anything, and don't keep targetting this block
                return false;
            }
        };
        LaserArmBlock.registerBlockBehavior(class_2246.field_22422, noop);
        LaserArmBlock.registerBlockBehavior(class_2246.field_9987, noop);
        
        transferPowerBehavior = new LaserArmBlockBehavior() {
            @Override
            public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
                var storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, blockEntity, null);
                
                if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider energyProvider)
                    storageCandidate = energyProvider.getEnergyStorage(null);
                
                if (blockEntity instanceof UnstableContainerBlockEntity unstableContainerBlockEntity)
                    storageCandidate = unstableContainerBlockEntity.laserInputStorage;
                
                var insertAmount = storageCandidate.getCapacity() - storageCandidate.getAmount();
                if (insertAmount <= 0)
                    return false;
                
                var transferCapacity = Math.min(insertAmount, laserEntity.energyRequiredToFire());
                
                if (storageCandidate instanceof DynamicEnergyStorage dynamicStorage) {
                    var inserted = dynamicStorage.insertIgnoringLimit(transferCapacity, true);
                    if (inserted > 0 && inserted <= transferCapacity) {
                        dynamicStorage.insertIgnoringLimit(transferCapacity, false);
                        dynamicStorage.update();
                        
                        if (blockEntity instanceof AtomicForgeBlockEntity atomicForgeBlock)
                            atomicForgeBlock.lastWorkedAt = world.method_8510();
                        
                        return true;
                    }
                    return false;
                } else {
                    var inserted = storageCandidate.insert(transferCapacity, true);
                    if (inserted > 0 && inserted <= transferCapacity) {
                        storageCandidate.insert(transferCapacity, false);
                        storageCandidate.update();
                        return true;
                    }
                    return false;
                }
            }
        };
        LaserArmBlock.registerBlockBehavior(BlockContent.ATOMIC_FORGE_BLOCK, transferPowerBehavior);
        LaserArmBlock.registerBlockBehavior(BlockContent.DEEP_DRILL_BLOCK, transferPowerBehavior);
        LaserArmBlock.registerBlockBehavior(BlockContent.ENCHANTMENT_CATALYST_BLOCK, transferPowerBehavior);
        
        energizeBuddingBehavior = new LaserArmBlockBehavior() {
            @Override
            public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
                
                if (world.method_8510() % 40 == 0) {    // periodically reset target
                    return false;
                }
                if (blockState.method_26215() || !blockState.method_26227().method_15769()) return false;
                
                blockState.method_26199((class_3218) world, blockPos, world.field_9229);
                ParticleContent.ACCELERATING.spawn(world, class_243.method_24954(blockPos));
                
                return true;
            }
        };
        
        LaserArmBlock.registerBlockBehavior(class_2246.field_27160, energizeBuddingBehavior);
    }
}
