package rearth.oritech.block.base.entity;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.FluidApi.FluidStorage;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.StackContext;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public abstract class FluidMultiblockGeneratorBlockEntity extends MultiblockGeneratorBlockEntity implements FluidApi.BlockProvider {
    
    @SyncField
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(4 * FluidStackHooks.bucketAmount(), this::method_5431) {
        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            if (toInsert.getFluid().equals(class_3612.field_15910)) return 0L;    // to avoid mixups with players inserting water for boiler into main storage
            return super.insert(toInsert, simulate);
        }
    };
    
    public FluidMultiblockGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        
        if (bucketInputAllowed() && !world.field_9236 && isActive(state)) {
            processBuckets();
        }
        
        super.serverTick(world, pos, state, blockEntity);
    }
    
    private void processBuckets() {
        
        var inStack = inventory.method_5438(0);
        var canFill = this.fluidStorage.getAmount() < this.fluidStorage.getCapacity();
        
        if (!canFill || inStack.method_7960() || inStack.method_7947() > 1) return;
        
        var stackRef = new StackContext(inStack, updated -> inventory.method_5447(0, updated));
        var candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsExtraction()) return;
        
        var moved = FluidApi.transferFirst(candidate, fluidStorage, fluidStorage.getCapacity(), false);
        
        if (moved == 0) {
            // move stack
            var outStack = inventory.method_5438(1);
            if (outStack.method_7960()) {
                inventory.method_5447(1, stackRef.getValue());
                inventory.method_5447(0, class_1799.field_8037);
            } else if (outStack.method_7909().equals(stackRef.getValue().method_7909()) && outStack.method_7947() < outStack.method_7914()) {
                outStack.method_7933(1);
                inventory.method_5447(0, class_1799.field_8037);
            }
        }
    }
    
    @Override
    protected void tryConsumeInput() {
        
        if (isProducingSteam && (boilerStorage.getInStack().getAmount() == 0 || boilerStorage.getOutStack().getAmount() >= boilerStorage.getCapacity())) return;
        
        var recipeCandidate = getRecipe();
        if (recipeCandidate.isEmpty())
            currentRecipe = OritechRecipe.DUMMY;     // reset recipe when invalid or no input is given
        
        
        if (recipeCandidate.isPresent()) {
            // this is separate so that progress is not reset when out of energy
            var activeRecipe = recipeCandidate.get().comp_1933();
            currentRecipe = activeRecipe;
            consumeFluidRecipeInput(activeRecipe);
            
        }
    }
    
    protected void consumeFluidRecipeInput(OritechRecipe activeRecipe) {
        var recipeTime = (int) (currentRecipe.getTime() * getSpeedMultiplier() * (1 / getEfficiencyMultiplier()));
        progress = recipeTime;
        setCurrentMaxBurnTime(recipeTime);
        
        // remove inputs
        // correct amount and variant is already validated in getRecipe, so we can directly remove it
        var fluidStack = fluidStorage.getStack().copyWithAmount(activeRecipe.getFluidInput().amount());
        fluidStorage.extract(fluidStack, false);
    }
    
    // gets all recipe of target type, and only checks for matching liquids
    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        return getRecipe(fluidStorage);
    }
    
    protected Optional<class_8786<OritechRecipe>> getRecipe(SimpleFluidStorage checkedTank) {
        return getRecipe(checkedTank, field_11863, getOwnRecipeType());
    }
    
    public static Optional<class_8786<OritechRecipe>> getRecipe(FluidApi.SingleSlotStorage checkedTank, class_1937 world, OritechRecipeType ownType) {
        
        if (checkedTank.getStack().isEmpty()) return Optional.empty();
        
        var availableRecipes = world.method_8433().method_30027(ownType);
        for (var recipeEntry : availableRecipes) {
            var recipe = recipeEntry.comp_1933();
            var recipeFluid = recipe.getFluidInput();
            if (recipeFluid.matchesFluid(checkedTank.getStack()) && checkedTank.getStack().getAmount() >= recipeFluid.amount())
                return Optional.of(recipeEntry);
        }
        
        return Optional.empty();
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        fluidStorage.writeNbt(nbt, "");
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        fluidStorage.readNbt(nbt, "");
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(new GuiSlot(0, 55, 35), new GuiSlot(1, 112, 35, true));
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }
    
    public boolean bucketInputAllowed() {
        return true;
    }
    
    @Override
    public int getInventorySize() {
        return 2;
    }
    
    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        return fluidStorage;
    }
}
