/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import org.apache.commons.lang3.time.StopWatch;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeBlock;
import rearth.oritech.block.blocks.pipes.item.ItemPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;

public class ItemPipeInterfaceEntity
extends ExtractablePipeInterfaceEntity {
    private static final int TRANSFER_AMOUNT = Oritech.CONFIG.itemPipeTransferAmount();
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.itemPipeIntervalDuration();
    private List<class_3545<ItemApi.InventoryStorage, class_2338>> filteredTargetItemStorages;
    private final HashMap<class_2338, class_3545<ArrayList<class_2338>, Integer>> cachedTransferPaths = new HashMap();
    private final boolean renderItems;
    private static final HashMap<class_2338, Long> blockedUntil = new HashMap();
    public Set<RenderStackData> activeStacks = new HashSet<RenderStackData>();

    public ItemPipeInterfaceEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ITEM_PIPE_ENTITY, pos, state);
        this.renderItems = state.method_26204().equals(BlockContent.TRANSPARENT_ITEM_PIPE_CONNECTION);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, GenericPipeInterfaceEntity blockEntity) {
        ExtractablePipeConnectionBlock block = (ExtractablePipeConnectionBlock)state.method_26204();
        if (world.field_9236 || !block.isExtractable(state)) {
            return;
        }
        if ((world.method_8510() + this.field_11867.method_10063()) % (long)TRANSFER_PERIOD != 0L && !this.isBoostAvailable()) {
            return;
        }
        GenericPipeInterfaceEntity.PipeNetworkData data = ItemPipeBlock.ITEM_PIPE_DATA.getOrDefault(world.method_27983().method_29177(), new GenericPipeInterfaceEntity.PipeNetworkData());
        Set sources = data.machineInterfaces.getOrDefault(pos, new HashSet());
        class_1799 stackToMove = class_1799.field_8037;
        ItemApi.InventoryStorage moveFromInventory = null;
        class_2338 takenFrom = null;
        int moveCapacity = this.isBoostAvailable() ? 64 : TRANSFER_AMOUNT;
        Boolean hasMotor = (Boolean)state.method_11654((class_2769)ItemPipeConnectionBlock.HAS_MOTOR);
        block0: for (class_2338 sourcePos : sources) {
            ItemApi.InventoryStorage inventory;
            class_2338 offset;
            class_2350 direction;
            Long blockedTimer = blockedUntil.getOrDefault(sourcePos, 0L);
            if (world.method_8510() < blockedTimer) continue;
            if (blockedTimer > 0L) {
                blockedUntil.remove(sourcePos);
            }
            if (!block.isSideExtractable(state, (direction = class_2350.method_50026((int)(offset = pos.method_10059((class_2382)sourcePos)).method_10263(), (int)offset.method_10264(), (int)offset.method_10260())).method_10153()) || (inventory = ItemApi.BLOCK.find(world, sourcePos, direction)) == null || !inventory.supportsExtraction()) continue;
            for (int i = 0; i < inventory.getSlotCount(); ++i) {
                int extracted;
                class_1799 slotStack = inventory.getStackInSlot(i);
                if (slotStack.method_7960()) continue;
                int canTake = inventory.extractFromSlot(slotStack.method_46651(moveCapacity), i, true);
                if (canTake > 0) {
                    stackToMove = slotStack.method_46651(canTake);
                    moveFromInventory = inventory;
                    takenFrom = sourcePos;
                } else {
                    stackToMove = class_1799.field_8037;
                }
                if (stackToMove.method_7960()) continue;
                Set<class_3545<class_2338, class_2350>> targets = ItemPipeInterfaceEntity.findNetworkTargets(pos, data);
                if (targets == null) {
                    System.err.println("Yeah your pipe network likely is too long. At: " + String.valueOf(this.method_11016()));
                    return;
                }
                int netHash = targets.hashCode();
                if (netHash != this.filteredTargetsNetHash || this.filteredTargetItemStorages == null) {
                    this.filteredTargetItemStorages = targets.stream().filter(target -> {
                        class_2350 targetDir = (class_2350)target.method_15441();
                        class_2338 pipePos = ((class_2338)target.method_15442()).method_10081(targetDir.method_10163());
                        class_2680 pipeState = world.method_8320(pipePos);
                        class_2248 patt0$temp = pipeState.method_26204();
                        if (!(patt0$temp instanceof ItemPipeConnectionBlock)) {
                            return true;
                        }
                        ItemPipeConnectionBlock itemBlock = (ItemPipeConnectionBlock)patt0$temp;
                        boolean extracting = itemBlock.isSideExtractable(pipeState, targetDir.method_10153());
                        return !extracting;
                    }).map(target -> new class_3545((Object)ItemApi.BLOCK.find(world, (class_2338)target.method_15442(), (class_2350)target.method_15441()), (Object)((class_2338)target.method_15442()))).filter(obj -> Objects.nonNull(obj.method_15442()) && ((ItemApi.InventoryStorage)obj.method_15442()).supportsInsertion()).sorted(Comparator.comparingInt(a -> ((class_2338)a.method_15441()).method_19455((class_2382)pos))).toList();
                    this.filteredTargetsNetHash = netHash;
                    this.cachedTransferPaths.clear();
                }
                int toMove = stackToMove.method_7947();
                int moved = 0;
                for (class_3545<ItemApi.InventoryStorage, class_2338> storagePair : this.filteredTargetItemStorages) {
                    if (((ItemApi.InventoryStorage)storagePair.method_15442()).equals(moveFromInventory)) continue;
                    ItemApi.InventoryStorage targetStorage = (ItemApi.InventoryStorage)storagePair.method_15442();
                    boolean wasEmptyStorage = IntStream.range(0, targetStorage.getSlotCount()).allMatch(slot -> targetStorage.getStackInSlot(slot).method_7960());
                    int inserted = targetStorage.insert(stackToMove, false);
                    toMove -= inserted;
                    moved += inserted;
                    if (inserted > 0) {
                        this.onItemMoved(this.field_11867, takenFrom, (class_2338)storagePair.method_15441(), data.pipeNetworks.getOrDefault(data.pipeNetworkLinks.getOrDefault(this.field_11867, 0), new HashSet()), world, stackToMove.method_7909(), inserted, wasEmptyStorage);
                    }
                    if (toMove > 0) continue;
                    break;
                }
                if ((extracted = moveFromInventory.extract(stackToMove.method_46651(moved), false)) != moved) {
                    Oritech.LOGGER.warn("Invalid state while transferring inventory. Caused at position {}", (Object)pos);
                }
                if (moved > 0 || !hasMotor.booleanValue()) continue block0;
            }
        }
        if (moveCapacity > TRANSFER_AMOUNT) {
            this.onBoostUsed();
        }
    }

    private void onItemMoved(class_2338 startPos, class_2338 from, class_2338 to, Set<class_2338> network, class_1937 world, class_1792 moved, int movedCount, boolean wasEmpty) {
        if (!this.renderItems) {
            return;
        }
        class_3545 path = this.cachedTransferPaths.computeIfAbsent(to, ignored -> ItemPipeInterfaceEntity.calculatePath(startPos, from, to, network, world));
        if (path == null) {
            return;
        }
        ArrayList codedPath = (ArrayList)path.method_15442();
        int pathLength = 0;
        for (int i = 0; i < codedPath.size() - 1; ++i) {
            class_2338 pathPos = (class_2338)codedPath.get(i);
            class_2338 nextPathPos = (class_2338)codedPath.get(i + 1);
            pathLength += nextPathPos.method_19455((class_2382)pathPos);
        }
        RenderStackData packet = new RenderStackData(this.field_11867, new class_1799((class_1935)moved, movedCount), codedPath, world.method_8510(), pathLength);
        NetworkManager.sendBlockHandle(this, packet);
        if (wasEmpty) {
            long arrivalTime = world.method_8510() + (long)((int)ItemPipeInterfaceEntity.calculatePathLength((Integer)path.method_15441()));
            blockedUntil.putIfAbsent(to, arrivalTime);
        }
    }

    public static double calculatePathLength(int pathBlocksCount) {
        return Math.pow(pathBlocksCount * 32, 0.6);
    }

    private static class_3545<ArrayList<class_2338>, Integer> calculatePath(class_2338 startPos, class_2338 from, class_2338 to, Set<class_2338> network, class_1937 world) {
        class_2338 currentPos;
        if (network.isEmpty() || !network.contains(startPos)) {
            Oritech.LOGGER.warn("tried to calculate invalid item pipe from: {} to {} with network size: {}", new Object[]{startPos, to, network.size()});
            return null;
        }
        int length = 1;
        LinkedList<class_2338> path = new LinkedList<class_2338>();
        path.add(startPos);
        HashSet<class_2338> visited = new HashSet<class_2338>();
        StopWatch watch = new StopWatch();
        watch.start();
        for (int i = 0; i < network.size() * 3 && (currentPos = (class_2338)path.peekLast()) != null && currentPos.method_19455((class_2382)to) != 1; ++i) {
            visited.add(currentPos);
            class_2680 currentPosState = world.method_8320(currentPos);
            class_2248 class_22482 = currentPosState.method_26204();
            if (!(class_22482 instanceof AbstractPipeBlock)) break;
            AbstractPipeBlock pipeBlock = (AbstractPipeBlock)class_22482;
            class_2338[] openEdges = (class_2338[])ItemPipeInterfaceEntity.getNeighbors(currentPos).stream().filter(network::contains).filter(candidate -> !visited.contains(candidate)).filter(candidate -> pipeBlock.isConnectingInDirection(currentPosState, ItemPipeInterfaceEntity.getDirectionFromOffset(currentPos, candidate), currentPos, world, false)).sorted(Comparator.comparingInt(a -> a.method_19455((class_2382)to))).toArray(class_2338[]::new);
            if (openEdges.length == 0) {
                path.pollLast();
                continue;
            }
            path.add(openEdges[0]);
            ++length;
        }
        path.addFirst(from);
        path.add(to);
        ArrayList<class_2338> result = ItemPipeInterfaceEntity.optimizePath(path);
        watch.stop();
        Oritech.LOGGER.debug("pathsize: {} success: {} time ms: {}", new Object[]{result.size(), path.size() > 2, Float.valueOf((float)watch.getNanoTime() / 1000000.0f)});
        return new class_3545(result, (Object)path.size());
    }

    private static ArrayList<class_2338> optimizePath(LinkedList<class_2338> path) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        if (path.isEmpty()) {
            return result;
        }
        Iterator iterator = path.iterator();
        class_2338 first = (class_2338)iterator.next();
        result.add(first);
        if (!iterator.hasNext()) {
            return result;
        }
        class_2338 current = (class_2338)iterator.next();
        class_2338 currentDirection = current.method_10059((class_2382)first);
        while (iterator.hasNext()) {
            class_2338 next = (class_2338)iterator.next();
            class_2338 nextDirection = next.method_10059((class_2382)current);
            if (!nextDirection.equals((Object)currentDirection)) {
                result.add(current);
                currentDirection = nextDirection;
            }
            current = next;
        }
        result.add(current);
        return result;
    }

    private static List<class_2338> getNeighbors(class_2338 pos) {
        return Arrays.asList(pos.method_10074(), pos.method_10084(), pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067());
    }

    private static class_2350 getDirectionFromOffset(class_2338 self, class_2338 target) {
        class_2338 offset = target.method_10059((class_2382)self);
        return class_2350.method_50026((int)offset.method_10263(), (int)offset.method_10264(), (int)offset.method_10260());
    }

    public static void receiveVisualItemsPacket(RenderStackData message, class_1937 world, class_5455 registryAccess) {
        Optional blockEntity = world.method_35230(message.self, BlockEntitiesContent.ITEM_PIPE_ENTITY);
        if (blockEntity.isPresent()) {
            ItemPipeInterfaceEntity pipeEntity = (ItemPipeInterfaceEntity)((Object)blockEntity.get());
            pipeEntity.activeStacks.add(new RenderStackData(pipeEntity.field_11867, message.rendered, message.path, world.method_8510(), message.pathLength));
        }
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8524(this.field_11867);
        }
    }

    public record RenderStackData(class_2338 self, class_1799 rendered, List<class_2338> path, Long startedAt, int pathLength) implements class_8710
    {
        public static final class_8710.class_9154<RenderStackData> PIPE_ITEMS_ID = new class_8710.class_9154(Oritech.id("pipe_items"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PIPE_ITEMS_ID;
        }
    }
}

