/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.FrameInteractionBlock;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;

public abstract class FrameInteractionBlockEntity
extends NetworkedBlockEntity {
    private static final int MAX_SEARCH_LENGTH = Oritech.CONFIG.processingMachines.machineFrameMaxLength();
    private static final HashMap<class_2382, HashMap<class_2382, class_2382>> occupiedAreas = new HashMap();
    @SyncField(value={SyncType.INITIAL, SyncType.SPARSE_TICK})
    private class_2338 areaMin;
    @SyncField(value={SyncType.INITIAL, SyncType.SPARSE_TICK})
    private class_2338 areaMax;
    @SyncField(value={SyncType.INITIAL, SyncType.SPARSE_TICK})
    public boolean disabledViaRedstone;
    @SyncField
    private class_2338 currentTarget;
    @SyncField
    private class_2338 lastTarget;
    @SyncField
    private boolean moving;
    @SyncField
    private float currentProgress;
    private class_2382 currentDirection = new class_2382(1, 0, 0);
    public long lastWorkedAt;
    public class_243 lastRenderedPosition = new class_243(0.0, 0.0, 0.0);

    public FrameInteractionBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean tryFindFrame() {
        Oritech.LOGGER.debug("searching machine frame");
        class_2350 facing = this.getFacing();
        class_2382 backRelative = new class_2382(this.getFrameOffset(), 0, 0);
        class_2338 searchStart = (class_2338)Geometry.offsetToWorldPosition(facing, backRelative, (class_2382)this.field_11867);
        class_2338 endRightFront = this.searchFrameLine(searchStart, Geometry.getRight(facing));
        if (endRightFront.equals((Object)class_2338.field_10980)) {
            this.highlightBlock(searchStart);
            return false;
        }
        class_2338 endRightBack = this.searchFrameLine(endRightFront, Geometry.getBackward(facing));
        if (endRightBack.equals((Object)endRightFront)) {
            this.highlightBlock(endRightFront.method_10081(Geometry.getRight(facing)));
            this.highlightBlock(endRightFront.method_10081(Geometry.getBackward(facing)));
            return false;
        }
        class_2338 endLeftBack = this.searchFrameLine(endRightBack, Geometry.getLeft(facing));
        if (endLeftBack.equals((Object)endRightBack)) {
            this.highlightBlock(endRightBack.method_10081(Geometry.getBackward(facing)));
            this.highlightBlock(endRightBack.method_10081(Geometry.getLeft(facing)));
            return false;
        }
        class_2338 endLeftFront = this.searchFrameLine(endLeftBack, Geometry.getForward(facing));
        if (endLeftFront.equals((Object)endLeftBack)) {
            this.highlightBlock(endLeftBack.method_10081(Geometry.getLeft(facing)));
            this.highlightBlock(endLeftBack.method_10081(Geometry.getForward(facing)));
            return false;
        }
        class_2338 endMiddleFront = this.searchFrameLineEnd(endLeftFront, Geometry.getRight(facing), searchStart);
        if (endMiddleFront.equals((Object)endLeftFront)) {
            this.highlightBlock(endMiddleFront.method_10081(Geometry.getForward(facing)));
            this.highlightBlock(endMiddleFront.method_10081(Geometry.getRight(facing)));
            return false;
        }
        if (!endMiddleFront.equals((Object)searchStart)) {
            this.highlightBlock(endMiddleFront.method_10081(Geometry.getRight(facing)));
            return false;
        }
        boolean innerValid = this.checkInnerEmpty(endLeftBack, endRightFront);
        if (!innerValid) {
            return false;
        }
        int startX = Math.min(endLeftFront.method_10263(), endRightBack.method_10263()) + 1;
        int startZ = Math.min(endLeftFront.method_10260(), endRightBack.method_10260()) + 1;
        this.areaMin = new class_2338(startX, this.method_11016().method_10264(), startZ);
        int endX = Math.max(endLeftFront.method_10263(), endRightBack.method_10263()) - 1;
        int endZ = Math.max(endLeftFront.method_10260(), endRightBack.method_10260()) - 1;
        this.areaMax = new class_2338(endX, this.method_11016().method_10264(), endZ);
        if (this.currentTarget == null || !this.isInBounds(this.currentTarget)) {
            this.currentTarget = this.areaMin;
            this.lastTarget = this.areaMin;
        }
        this.method_5431();
        this.sendUpdate(SyncType.INITIAL);
        return true;
    }

    protected class_2350 getFacing() {
        return (class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12481);
    }

    private boolean checkInnerEmpty(class_2338 leftBack, class_2338 rightFront) {
        assert (this.field_11863 != null);
        int lengthX = Math.abs(leftBack.method_10263() - rightFront.method_10263());
        int lengthZ = Math.abs(leftBack.method_10260() - rightFront.method_10260());
        int dirX = leftBack.method_10263() - rightFront.method_10263() > 0 ? -1 : 1;
        int dirZ = leftBack.method_10260() - rightFront.method_10260() > 0 ? -1 : 1;
        boolean valid = true;
        for (int x = 1; x < lengthX; ++x) {
            for (int z = 1; z < lengthZ; ++z) {
                class_2338 offset = new class_2338(dirX * x, 0, dirZ * z);
                class_2338 checkPos = leftBack.method_10081((class_2382)offset);
                class_2248 foundBlock = this.field_11863.method_8320(checkPos).method_26204();
                if (foundBlock.equals(class_2246.field_10124)) continue;
                this.highlightBlock(checkPos);
                valid = false;
            }
        }
        return valid;
    }

    private class_2338 searchFrameLine(class_2338 searchStart, class_2382 direction) {
        class_2338 checkPos;
        class_2338 lastPosition = class_2338.field_10980;
        for (int i = 0; i < MAX_SEARCH_LENGTH && this.testForFrame(checkPos = searchStart.method_10081(direction.method_35862(i))); ++i) {
            lastPosition = checkPos;
        }
        return lastPosition;
    }

    private class_2338 searchFrameLineEnd(class_2338 searchStart, class_2382 direction, class_2338 searchEnd) {
        class_2338 checkPos;
        class_2338 lastPosition = class_2338.field_10980;
        for (int i = 0; i < MAX_SEARCH_LENGTH && this.testForFrame(checkPos = searchStart.method_10081(direction.method_35862(i))); ++i) {
            if (checkPos.equals((Object)searchEnd)) {
                Oritech.LOGGER.debug("found start, machine is valid");
                return checkPos;
            }
            lastPosition = checkPos;
        }
        return lastPosition;
    }

    private boolean testForFrame(class_2338 pos) {
        class_2248 found = this.field_11863.method_8320(pos).method_26204();
        return found.equals(BlockContent.MACHINE_FRAME_BLOCK);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state) || !((Boolean)state.method_11654((class_2769)FrameInteractionBlock.HAS_FRAME)).booleanValue() || this.getAreaMin() == null) {
            return;
        }
        if (!this.canProgress()) {
            return;
        }
        while ((double)this.currentProgress > 0.01) {
            if (!this.moving && this.currentProgress >= this.getWorkTime()) {
                this.method_5431();
                if (!this.startBlockMove()) break;
                this.currentProgress -= this.getWorkTime();
                this.finishBlockWork(this.lastTarget);
                this.updateToolPosInFrame();
                this.moving = true;
                continue;
            }
            if (!this.moving || !(this.currentProgress >= this.getMoveTime())) break;
            this.method_5431();
            if (this.hasWorkAvailable(this.currentTarget)) {
                this.moving = false;
                this.currentProgress -= this.getMoveTime();
                continue;
            }
            if (!this.startBlockMove()) break;
            this.updateToolPosInFrame();
            this.currentProgress -= this.getMoveTime();
        }
        this.doProgress(this.moving);
        this.currentProgress += 1.0f;
        this.lastWorkedAt = world.method_8510();
    }

    @Override
    public int getTickUpdateInterval() {
        return 1;
    }

    private boolean isBlockAvailable(class_2338 target) {
        if (!occupiedAreas.containsKey(this.areaMin)) {
            occupiedAreas.put((class_2382)this.areaMin, new HashMap(1));
            return true;
        }
        HashMap<class_2382, class_2382> frameEntries = occupiedAreas.get(this.areaMin);
        return !frameEntries.containsValue(target);
    }

    private void updateToolPosInFrame() {
        HashMap<class_2382, class_2382> frameEntries = occupiedAreas.get(this.areaMin);
        frameEntries.put((class_2382)this.field_11867, (class_2382)this.currentTarget);
    }

    public void cleanup() {
        HashMap<class_2382, class_2382> frameEntries = occupiedAreas.get(this.areaMin);
        if (frameEntries != null) {
            frameEntries.remove(this.field_11867);
        }
    }

    protected abstract boolean hasWorkAvailable(class_2338 var1);

    protected abstract void doProgress(boolean var1);

    protected abstract boolean canProgress();

    public abstract void finishBlockWork(class_2338 var1);

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (((Boolean)this.method_11010().method_11654((class_2769)FrameInteractionBlock.HAS_FRAME)).booleanValue() && this.areaMin != null) {
            nbt.method_10544("areaMin", this.areaMin.method_10063());
            nbt.method_10544("areaMax", this.areaMax.method_10063());
            if (this.currentTarget != null) {
                nbt.method_10544("currentTarget", this.currentTarget.method_10063());
            }
            if (this.currentDirection != null) {
                nbt.method_10544("currentDirection", new class_2338(this.currentDirection).method_10063());
            }
            nbt.method_10569("progress", (int)this.currentProgress);
            nbt.method_10556("moving", this.moving);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (((Boolean)this.method_11010().method_11654((class_2769)FrameInteractionBlock.HAS_FRAME)).booleanValue()) {
            this.areaMin = class_2338.method_10092((long)nbt.method_10537("areaMin"));
            this.areaMax = class_2338.method_10092((long)nbt.method_10537("areaMax"));
            this.currentTarget = class_2338.method_10092((long)nbt.method_10537("currentTarget"));
            this.currentDirection = class_2338.method_10092((long)nbt.method_10537("currentDirection"));
            this.lastTarget = this.currentTarget;
            this.currentProgress = nbt.method_10550("progress");
            this.moving = nbt.method_10577("moving");
        }
    }

    private boolean startBlockMove() {
        class_2338 nextPos = this.currentTarget.method_10081(this.currentDirection);
        class_2382 nextDir = this.currentDirection;
        if (!this.isInBounds(nextPos)) {
            nextPos = this.currentTarget.method_10069(0, 0, 1);
            nextDir = this.currentDirection.method_35862(-1);
            if (!this.isInBounds(nextPos)) {
                class_3545<class_2338, class_2338> data = this.resetWorkPosition();
                nextPos = (class_2338)data.method_15442();
                nextDir = (class_2382)data.method_15441();
            }
        }
        if (!this.isBlockAvailable(nextPos) && this.currentProgress <= this.getWorkTime() * this.getSpeedMultiplier() * 2.0f + 4.0f) {
            return false;
        }
        this.lastTarget = this.currentTarget;
        this.currentTarget = nextPos;
        this.currentDirection = nextDir;
        return true;
    }

    private class_3545<class_2338, class_2338> resetWorkPosition() {
        return new class_3545((Object)this.areaMin, (Object)new class_2338(1, 0, 0));
    }

    private boolean isInBounds(class_2338 pos) {
        return pos.method_10263() >= this.areaMin.method_10263() && pos.method_10263() <= this.areaMax.method_10263() && pos.method_10260() >= this.areaMin.method_10260() && pos.method_10260() <= this.areaMax.method_10260();
    }

    private void highlightBlock(class_2338 block) {
        ParticleContent.HIGHLIGHT_BLOCK.spawn(this.field_11863, class_243.method_24954((class_2382)block), null);
    }

    public abstract class_2680 getMachineHead();

    public int getFrameOffset() {
        return 1;
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public class_2338 getAreaMin() {
        return this.areaMin;
    }

    public void setAreaMin(class_2338 areaMin) {
        this.areaMin = areaMin;
    }

    public class_2338 getAreaMax() {
        return this.areaMax;
    }

    public void setAreaMax(class_2338 areaMax) {
        this.areaMax = areaMax;
    }

    public class_2338 getCurrentTarget() {
        return this.currentTarget;
    }

    public void setCurrentTarget(class_2338 currentTarget) {
        this.currentTarget = currentTarget;
    }

    public class_2338 getLastTarget() {
        return this.lastTarget;
    }

    public void setLastTarget(class_2338 lastTarget) {
        this.lastTarget = lastTarget;
    }

    public int getCurrentProgress() {
        return (int)this.currentProgress;
    }

    public void setCurrentProgress(int currentProgress) {
        this.currentProgress = currentProgress;
    }

    public boolean isActive(class_2680 state) {
        return true;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public class_2382 getCurrentDirection() {
        return this.currentDirection;
    }

    public void setCurrentDirection(class_2382 currentDirection) {
        this.currentDirection = currentDirection;
    }

    public abstract float getMoveTime();

    public abstract float getWorkTime();

    public class_1799 getToolheadAdditionalRender() {
        return null;
    }

    @Override
    public void sendUpdate(SyncType type) {
        if (this.currentTarget == null || this.lastTarget == null) {
            return;
        }
        super.sendUpdate(type);
    }
}

