package rearth.oritech.block.entity.accelerator;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.wispforest.owo.util.VectorRandomUtils;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi.EnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.AcceleratorScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9797;

// networking: last event could be automated. Inject event can just be called on server, and let vanilla handle sounds. Trail should be sent normally,
// so maybe everything could just be moved to manually sent packets
public class AcceleratorControllerBlockEntity extends class_2586 implements class_5558<AcceleratorControllerBlockEntity>, ItemApi.BlockProvider, ExtendedMenuProvider, ScreenProvider {
    
    private AcceleratorParticleLogic.ActiveParticle particle;
    private AcceleratorParticleLogic.ActiveParticle lastParticle;
    public class_1799 activeItemParticle = class_1799.field_8037;
    
    private AcceleratorParticleLogic particleLogic;
    
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(2, this::method_5431, new InventorySlotAssignment(0, 1, 1, 1));
    
    // client data
    public List<class_243> displayTrail;
    public LastEventPacket lastEvent = new LastEventPacket(field_11867, ParticleEvent.IDLE, 0, field_11867, 1, class_1799.field_8037);
    
    public AcceleratorControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ACCELERATOR_CONTROLLER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, AcceleratorControllerBlockEntity blockEntity) {
        if (world.field_9236) return;
        initParticleLogic();
        
        // try insert item as particle
        if (particle == null && !inventory.method_5438(0).method_7960() && inventory.method_5438(1).method_7960()) {
            injectParticle();
        }
        
        if (particle != null)
            particleLogic.update(particle);
        
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        
        if (particle != null && activeItemParticle != null && activeItemParticle != class_1799.field_8037) {
            var data = new class_2487();
            data.method_10548("speed", particle.velocity);
            data.method_10548("posX", (float) particle.position.field_1352);
            data.method_10548("posY", (float) particle.position.field_1351);
            data.method_10548("posZ", (float) particle.position.field_1350);
            data.method_10544("lastGate", particle.lastGate.method_10063());
            data.method_10544("nextGate", particle.nextGate.method_10063());
            data.method_10566("item", activeItemParticle.method_57358(registryLookup));
            nbt.method_10566("particle", data);
        } else {
            nbt.method_10551("particle");
        }
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        
        if (nbt.method_10545("particle")) {
            var data = nbt.method_10562("particle");
            var speed = data.method_10583("speed");
            var posX = data.method_10583("posX");
            var posY = data.method_10583("posY");
            var posZ = data.method_10583("posZ");
            var lastGate = class_2338.method_10092(data.method_10537("lastGate"));
            var nextGate = class_2338.method_10092(data.method_10537("nextGate"));
            var item = class_1799.method_57360(registryLookup, data.method_10580("item"));
            
            item.ifPresent(stack -> activeItemParticle = stack);
            particle = new AcceleratorParticleLogic.ActiveParticle(new class_243(posX, posY, posZ), speed, lastGate, nextGate);
        }
    }
    
    private void initParticleLogic() {
        if (particleLogic == null) particleLogic = new AcceleratorParticleLogic(field_11867, (class_3218) field_11863, this);
    }
    
    public void injectParticle() {
        
        var facing = method_11010().method_11654(class_2741.field_12481);
        var posBehind = Geometry.offsetToWorldPosition(facing, new class_2382(1, 0, 0), field_11867);
        var directionRight = Geometry.getRight(facing);
        
        var candidateBlock = field_11863.method_8320(new class_2338(posBehind));
        if (candidateBlock.method_26204().equals(BlockContent.ACCELERATOR_RING)) {
            var startPosition = (class_2338) posBehind;
            var nextGate = particleLogic.findNextGate(startPosition, directionRight, 1);
            particle = new AcceleratorParticleLogic.ActiveParticle(startPosition.method_46558(), 1, nextGate, startPosition);
            activeItemParticle = inventory.method_5438(0).method_7971(1);
            
            var soundPos = field_11867.method_46558();
            field_11863.method_54762(null, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, class_3417.field_40065, class_3419.field_15245);
        }
    }
    
    public void removeParticleDueToCollision() {
        this.particle = null;
        this.activeItemParticle = class_1799.field_8037;
    }
    
    public void onParticleExited(class_243 from, class_243 to, class_2338 lastGate, class_243 exitDirection, ParticleEvent reason) {
        
        var eventPosition = class_2338.method_49638(particle.position);
        NetworkManager.sendBlockHandle(this, new LastEventPacket(field_11867, reason, particle.velocity, eventPosition, AcceleratorParticleLogic.getParticleBendDist(particle.lastBendDistance, particle.lastBendDistance2), activeItemParticle));
        
        this.lastParticle = particle;
        this.particle = null;
        
        var renderedTrail = List.of(from, to);
        NetworkManager.sendBlockHandle(this, new ParticleRenderTrail(field_11867, renderedTrail));
        
        this.method_5431();
    }
    
    public void onParticleCollided(float relativeSpeed, class_243 collision, AcceleratorControllerBlockEntity secondControllerEntity) {
        
        // create end portal area when two ender pearls collide, nether portal for two firecharges
        if (relativeSpeed > Oritech.CONFIG.endPortalRequiredSpeed() && activeItemParticle.method_7909().equals(class_1802.field_8634) && secondControllerEntity.activeItemParticle.method_7909().equals(class_1802.field_8634)) {
            spawnEndPortal(class_2338.method_49638(collision));
        } else if (relativeSpeed > Oritech.CONFIG.netherPortalRequiredSpeed() && activeItemParticle.method_7909().equals(class_1802.field_8814) && secondControllerEntity.activeItemParticle.method_7909().equals(class_1802.field_8814)) {
            spawnNetherPortal(class_2338.method_49638(collision));
        } else {
            var success = tryCraftResult(relativeSpeed, activeItemParticle, secondControllerEntity.activeItemParticle);
        }
        
        NetworkManager.sendBlockHandle(this, new LastEventPacket(field_11867, ParticleEvent.COLLIDED, relativeSpeed, class_2338.method_49638(particle.position), AcceleratorParticleLogic.getParticleBendDist(particle.lastBendDistance, particle.lastBendDistance2), activeItemParticle));
        NetworkManager.sendBlockHandle(this, new LastEventPacket(secondControllerEntity.method_11016(), ParticleEvent.COLLIDED, relativeSpeed, class_2338.method_49638(particle.position), AcceleratorParticleLogic.getParticleBendDist(particle.lastBendDistance, particle.lastBendDistance2), activeItemParticle));
        
        this.removeParticleDueToCollision();
        secondControllerEntity.removeParticleDueToCollision();
        
        var particleCount = Math.pow(relativeSpeed, 0.5) / 2f + 1;
        createCollisionParticles((int) relativeSpeed, collision, (int) particleCount);
        
        ParticleContent.PARTICLE_COLLIDE.spawn(field_11863, collision);
        this.method_5431();
    }
    
    private void createCollisionParticles(int collisionEnergy, class_243 collisionPosition, int shotCount) {
        
        var energyMultiplier = 3 * Oritech.CONFIG.tachyonCollisionEnergyFactor();
        int energyPotential = (int) (Math.pow(collisionEnergy / 2f, 2) * energyMultiplier * Oritech.CONFIG.accelerationRFCost());    // exactly N times the amount of energy used to accelerate
        var energyPerRay = energyPotential / shotCount;
        var rayRange = shotCount / 3;
        
        var caughtParticles = 0;
        
        for (int i = 0; i < shotCount; i++) {
            var offset = VectorRandomUtils.getRandomOffset(field_11863, collisionPosition, rayRange);
            var direction = offset.method_1020(collisionPosition).method_1029();
            
            var impactPos = BlackHoleBlockEntity.basicRaycast(collisionPosition.method_1019(direction.method_1021(1.2)), direction, rayRange, field_11863);
            if (impactPos != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(field_11863, collisionPosition, impactPos.method_46558());
                // ParticleContent.DEBUG_BLOCK.spawn(world, Vec3d.of(impactPos));
                
                var candidate = field_11863.method_8321(impactPos);
                if (candidate instanceof ParticleCollectorBlockEntity collectorEntity) {
                    collectorEntity.onParticleCollided(energyPerRay);
                    caughtParticles++;
                }
            } else {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(field_11863, collisionPosition, offset);
            }
            
            // System.out.println("caught: " + caughtParticles + " of " + shotCount);
        }
    
    }
    
    private boolean tryCraftResult(float speed, class_1799 inputA, class_1799 inputB) {
        
        if (inputA == null || inputA.method_7960() || inputB == null || inputB.method_7960()) return false;
        
        var inputInv = new SimpleCraftingInventory(inputA, inputB);
        var candidate = field_11863.method_8433().method_8132(RecipeContent.PARTICLE_COLLISION, inputInv, field_11863);
        
        if (candidate.isEmpty()) {
            // try again in different order
            inputInv = new SimpleCraftingInventory(inputB, inputA);
            candidate = field_11863.method_8433().method_8132(RecipeContent.PARTICLE_COLLISION, inputInv, field_11863);
        }
        
        if (candidate.isEmpty()) return false;
        
        var recipe = candidate.get().comp_1933();
        
        var requiredSpeed = recipe.getTime();
        if (speed < requiredSpeed) return false;
        
        var result = recipe.getResults();
        if (inventory.heldStacks.get(1).method_7909().equals(result.get(0).method_7909())) {
            inventory.heldStacks.get(1).method_7933(1);
        } else {
            inventory.method_5447(1, result.get(0).method_7972());
        }
        
        return true;
    }
    
    private void spawnEndPortal(class_2338 pos) {
        
        // create small end area around the portal
        for (var candidate : class_2338.method_25996(pos, 8, 4, 8)) {
            
            var dist = candidate.method_46558().method_1022(pos.method_46558());
            if (field_11863.field_9229.method_43057() < dist / 8) continue;
            
            var candidateState = field_11863.method_8320(candidate);
            if (candidateState.method_26215() || candidateState.method_45474() || candidateState.method_26204().method_36555() < 0)
                continue;
            
            if (!field_11863.method_8320(candidate.method_10074()).method_26204().equals(class_2246.field_10021))
                field_11863.method_8501(candidate, class_2246.field_10471.method_9564());
            
            // generate chorus flowers
            if (field_11863.field_9229.method_43057() > 0.8) {
                var stateAbove = field_11863.method_8320(candidate.method_10084());
                if (stateAbove.method_26215() || stateAbove.method_45474()) {
                    for (int i = 1; i < field_11863.field_9229.method_39332(3, 6); i++) {
                        stateAbove = field_11863.method_8320(candidate.method_10086(i));
                        if (stateAbove.method_26215() || stateAbove.method_45474())
                            field_11863.method_8501(candidate.method_10086(i), class_2246.field_10021.method_9564());
                    }
                }
            }
        }
        
        // create portal itself
        field_11863.method_8501(pos, class_2246.field_10027.method_9564());
        field_11863.method_8501(pos.method_10095(), class_2246.field_10471.method_9564());
        field_11863.method_8501(pos.method_10078(), class_2246.field_10471.method_9564());
        field_11863.method_8501(pos.method_10072(), class_2246.field_10471.method_9564());
        field_11863.method_8501(pos.method_10067(), class_2246.field_10471.method_9564());
    }
    
    private void spawnNetherPortal(class_2338 pos) {
        
        // create small nether area around the portal
        for (var candidate : class_2338.method_25996(pos, 12, 4, 12)) {
            
            var dist = candidate.method_46558().method_1022(pos.method_46558());
            if (field_11863.field_9229.method_43057() < dist / 12) continue;
            
            var candidateState = field_11863.method_8320(candidate);
            if (candidateState.method_26215() || candidateState.method_45474() || candidateState.method_26204().method_36555() < 0)
                continue;
            
            field_11863.method_8501(candidate, class_2246.field_10515.method_9564());
            
            // generate fires
            if (field_11863.field_9229.method_43057() > 0.8) {
                var stateAbove = field_11863.method_8320(candidate.method_10084());
                if (stateAbove.method_26215() || stateAbove.method_45474()) {
                    field_11863.method_8501(candidate.method_10084(), class_2246.field_10036.method_9564());
                }
            }
        }
        
        // spawn obsidian frame (3x4), with 2 portal blocks in the center
        for (int x = 0; x < 3; x++) {
            for (int y = 0; y < 4; y++) {
                field_11863.method_8501(pos.method_10069(x, y, 0), class_2246.field_10540.method_9564());
            }
        }
        
        field_11863.method_8501(pos.method_10069(1, 1, 0), class_2246.field_10316.method_9564());
        field_11863.method_8501(pos.method_10069(1, 2, 0), class_2246.field_10316.method_9564());
        
    }
    
    public void onParticleMoved(List<class_243> positions) {
        
        if (positions.size() <= 1) return;
        
        var resultList = new ArrayList<class_243>();
        
        // deduplicate / shorten list
        var positionSet = new HashSet<class_243>();
        for (var position : positions) {
            if (positionSet.contains(position)) {
                // loop reached, stop the list
                break;
            }
            
            positionSet.add(position);
            resultList.add(position);
        }
        
        NetworkManager.sendBlockHandle(this, new ParticleRenderTrail(field_11867, resultList));
        NetworkManager.sendBlockHandle(this, new LastEventPacket(field_11867, ParticleEvent.ACCELERATING, particle.velocity, class_2338.method_49638(particle.position), AcceleratorParticleLogic.getParticleBendDist(particle.lastBendDistance, particle.lastBendDistance2), activeItemParticle));
        
    }
    
    public AcceleratorParticleLogic.ActiveParticle getParticle() {
        if (particle == null && lastParticle != null) return lastParticle;  // helper for edge case collisions
        return particle;
    }
    
    // returns the amount of moment used
    public float handleParticleEntityCollision(class_2338 checkPos, AcceleratorParticleLogic.ActiveParticle particle, float remainingMomentum, class_1309 mob) {
        
        var maxApplicableDamage = mob.method_6032();
        var inflictedDamage = Math.min(remainingMomentum, maxApplicableDamage);
        mob.method_5643(field_11863.method_48963().method_48831(), remainingMomentum);
        var position = mob.method_5829().method_1005();
        position = new class_243(position.field_1352, particle.position.field_1351, position.field_1350);
        ParticleContent.BIG_HIT.spawn(field_11863, position);
        
        return inflictedDamage;
    }
    
    public float handleParticleBlockCollision(class_2338 checkPos, AcceleratorParticleLogic.ActiveParticle particle, float remainingMomentum, class_2680 hitState) {
        
        var blockHardness = hitState.method_26214(field_11863, checkPos);
        
        // hit portal, create black hole with explosion
        if (remainingMomentum > Oritech.CONFIG.blackHoleRequiredSpeed() && hitState.method_26204() instanceof class_9797) {
            createBlackHole(checkPos);
            return remainingMomentum;
        }
        
        if (blockHardness < 0)  // unbreakable block
            return remainingMomentum;
        
        if (remainingMomentum > blockHardness) {
            field_11863.method_31595(checkPos, hitState);
            field_11863.method_8396(null, checkPos, hitState.method_26231().method_10595(), class_3419.field_15245, 1f, 1f);
            field_11863.method_22352(checkPos, true);
        }
        
        return blockHardness;
    }
    
    private void createBlackHole(class_2338 checkPos) {
        ParticleContent.MELTDOWN_IMMINENT.spawn(field_11863, checkPos.method_46558(), 30);
        
        var center = checkPos.method_46558();
        field_11863.method_8537(null, center.field_1352, center.field_1351, center.field_1350, 10, false, class_1937.class_7867.field_40889);
        
        field_11863.method_8650(checkPos, false);
        field_11863.method_8501(checkPos, BlockContent.BLACK_HOLE_BLOCK.method_9564());
    }
    
    public void handleParticleMotorInteraction(class_2338 motorBlock) {
        
        var entity = field_11863.method_8321(motorBlock);
        if (!(entity instanceof AcceleratorMotorBlockEntity motorEntity)) return;
        
        var storage = motorEntity.getEnergyStorage(null);
        var availableEnergy = storage.getAmount();
        
        var speed = particle.velocity;
        var cost = speed * Oritech.CONFIG.accelerationRFCost();
        if (availableEnergy < cost) return;
        
        storage.extract((long) cost, false);
        storage.update();
        
        particle.velocity += 1;
        
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new AcceleratorScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(new GuiSlot(0, 7, 10),
          new GuiSlot(1, 7, 60, true));
    }
    
    @Override
    public boolean showEnergy() {
        return false;
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ACCELERATOR_SCREEN;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    public static void receiveTrail(ParticleRenderTrail packet, class_1937 world, class_5455 dynamicRegistryManager) {
        if (world.method_8321(packet.position) instanceof AcceleratorControllerBlockEntity acceleratorBlock) {
            var displayTrail = packet.particleTrail;
            acceleratorBlock.displayTrail = displayTrail;
            if (displayTrail.size() < 2) return;
            
            var playerPos = class_310.method_1551().field_1724.method_19538();
            
            // play sound pos at closest segment
            var minDist = Double.MAX_VALUE;
            var soundPos = displayTrail.getFirst();
            for (var candidate : displayTrail) {
                var dist = candidate.method_1022(playerPos);
                if (dist < minDist) {
                    minDist = dist;
                    soundPos = candidate;
                }
            }
            
            var pitch = Math.pow(acceleratorBlock.lastEvent.lastEventSpeed, 0.1);
            world.method_8486(soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, SoundContent.PARTICLE_MOVING, class_3419.field_15245, 2f, (float) pitch, true);
            
        }
    }
    
    public static void receiveEvent(LastEventPacket packet, class_1937 world, class_5455 dynamicRegistryManager) {
        if (world.method_8321(packet.position) instanceof AcceleratorControllerBlockEntity acceleratorBlock) {
            acceleratorBlock.lastEvent = packet;
            
            var soundPos = packet.lastEventPosition.method_46558();
            if (packet.lastEvent.equals(ParticleEvent.COLLIDED)) {
                world.method_8486(soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, class_3417.field_38830, class_3419.field_15245, 5f, 1, true);
            } else if (packet.lastEvent.equals(ParticleEvent.EXITED_FAST) || packet.lastEvent.equals(ParticleEvent.EXITED_NO_GATE)) {
                world.method_8486(soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, class_3417.field_49044.comp_349(), class_3419.field_15245, 3f, 1, true);
            }
        }
    }
    
    public record LastEventPacket(class_2338 position,
                                  ParticleEvent lastEvent,
// for no gate found events, we can calculate the acceptable dist based on speed
                                  float lastEventSpeed,
// this is particle speed usually, and collision speed for collisions
                                  class_2338 lastEventPosition,  // where it collided/exited
                                  float minBendDist,   // acceptable dist can be calculated from dist
                                  class_1799 activeParticle
    ) implements class_8710 {
        
        public static final class_8710.class_9154<LastEventPacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("accel_event"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
    
    public enum ParticleEvent {
        IDLE,   // nothing was insert yet
        ERROR,  // no ring was found
        ACCELERATING,   // particle is in collider
        COLLIDED,
        EXITED_FAST,    // particle was too fast to take curve
        EXITED_NO_GATE  // no gate found in range
    }
    
    public record ParticleRenderTrail(class_2338 position, List<class_243> particleTrail) implements class_8710 {
        
        public static final class_8710.class_9154<ParticleRenderTrail> PACKET_ID = new class_8710.class_9154<>(Oritech.id("accel_render"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}
