package rearth.oritech.block.blocks.pipes.item;

import org.apache.commons.lang3.function.TriFunction;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_437;

public class ItemPipeBlock extends GenericPipeBlock {
    
    public static HashMap<class_2960, GenericPipeInterfaceEntity.PipeNetworkData> ITEM_PIPE_DATA = new HashMap<>();
    
    public ItemPipeBlock(class_2251 settings) {
        super(settings);
    }
    
    @Override
    public TriFunction<class_1937, class_2338, class_2350, Boolean> apiValidationFunction() {
        return ((world, pos, direction) -> ItemApi.BLOCK.find(world, pos, direction) != null);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        
        var showExtra = class_437.method_25441();
        if (showExtra) {
            for (int i = 1; i <= 4; i++) {
                tooltip.add(class_2561.method_43471("tooltip.oritech.item_pipe." + i).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
            }
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
        
        super.method_9568(stack, context, tooltip, options);
    }
    
    @Override
    public class_2680 getConnectionBlock() {
        return BlockContent.ITEM_PIPE_CONNECTION.method_9564();
    }
    
    @Override
    public class_2680 getNormalBlock() {
        return BlockContent.ITEM_PIPE.method_9564();
    }
    
    @Override
    protected class_265[] createShapes() {
        return THIN_SHAPES;
    }
    
    @Override
    public String getPipeTypeName() {
        return "item";
    }
    
    @Override
    public boolean connectToOwnBlockType(class_2248 block) {
        return block instanceof ItemPipeBlock || block instanceof ItemPipeConnectionBlock || block instanceof ItemPipeDuctBlock;
    }
    
    @Override
    public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(class_1937 world) {
        return ITEM_PIPE_DATA.computeIfAbsent(world.method_27983().method_29177(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
    }
    
    public static class FramedItemPipeBlock extends ItemPipeBlock {
        
        public FramedItemPipeBlock(class_2251 settings) {
            super(settings);
        }
        
        @Override
        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return class_259.method_1077();
        }
        
        @Override
        public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return state.method_26218(world, pos);
        }
        
        @Override
        public class_2680 getNormalBlock() {
            return BlockContent.FRAMED_ITEM_PIPE.method_9564();
        }
        
        @Override
        public class_2680 getConnectionBlock() {
            return BlockContent.FRAMED_ITEM_PIPE_CONNECTION.method_9564();
        }
        
    }
    
    public static class TransparentItemPipe extends ItemPipeBlock {
        
        public TransparentItemPipe(class_2251 settings) {
            super(settings);
        }
        
        @Override
        protected class_265[] createShapes() {
            return THICK_SHAPES;
        }
        
        @Override
        public class_2680 getNormalBlock() {
            return BlockContent.TRANSPARENT_ITEM_PIPE.method_9564();
        }
        
        @Override
        public class_2680 getConnectionBlock() {
            return BlockContent.TRANSPARENT_ITEM_PIPE_CONNECTION.method_9564();
        }
    }
}
