/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.HashSet;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import rearth.oritech.block.entity.pipes.ItemPipeInterfaceEntity;

public class ItemPipeTransferRenderer
implements class_827<ItemPipeInterfaceEntity> {
    public void render(ItemPipeInterfaceEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (entity.activeStacks == null || entity.activeStacks.isEmpty()) {
            return;
        }
        float time = (float)entity.method_10997().method_8510() + tickDelta;
        HashSet<ItemPipeInterfaceEntity.RenderStackData> removedStacks = new HashSet<ItemPipeInterfaceEntity.RenderStackData>();
        for (ItemPipeInterfaceEntity.RenderStackData renderedStack : entity.activeStacks) {
            double neededTime;
            float age = time - (float)renderedStack.startedAt().longValue();
            double progress = (double)age / (neededTime = ItemPipeInterfaceEntity.calculatePathLength(renderedStack.pathLength()));
            if (progress > 1.0) {
                removedStacks.add(renderedStack);
                continue;
            }
            progress = ItemPipeTransferRenderer.sigmoidFitted(progress);
            double targetPathProgress = (double)renderedStack.pathLength() * progress;
            int pathProgress = 0;
            class_2338 pathPosition = renderedStack.path().getFirst();
            class_243 targetPos = class_243.field_1353;
            for (class_2338 segment : renderedStack.path()) {
                int segmentDist = segment.method_19455((class_2382)pathPosition);
                if ((double)(pathProgress + segmentDist) < targetPathProgress) {
                    pathProgress += segmentDist;
                    pathPosition = segment;
                    continue;
                }
                double remainingDist = targetPathProgress - (double)pathProgress;
                class_243 targetOffset = class_243.method_24954((class_2382)segment.method_10059((class_2382)pathPosition)).method_1029().method_1021(remainingDist);
                targetPos = class_243.method_24954((class_2382)pathPosition).method_1019(targetOffset);
                break;
            }
            class_243 offset = targetPos.method_1020(class_243.method_24954((class_2382)entity.method_11016()));
            matrices.method_22903();
            matrices.method_22904(offset.field_1352 + 0.5, offset.field_1351 + 0.5, offset.field_1350 + 0.5);
            matrices.method_22905(0.4f, 0.4f, 0.4f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-140.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-30.0f));
            class_1799 renderedItem = renderedStack.rendered();
            class_310.method_1551().method_1480().method_23178(renderedItem, class_811.field_4317, light, class_4608.field_21444, matrices, vertexConsumers, entity.method_10997(), 0);
            matrices.method_22909();
        }
        entity.activeStacks.removeAll(removedStacks);
    }

    private static double sigmoidFitted(double x) {
        return ItemPipeTransferRenderer.sigmoid((x - 0.5) * 2.0) + 0.5;
    }

    private static double sigmoid(double x) {
        return x / (1.0 + Math.abs(x));
    }
}

