package rearth.oritech.block.blocks.addons;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.TooltipHelper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_437;

public class CombiAddonBlock extends MachineAddonBlock {
    
    public CombiAddonBlock(class_2251 settings, AddonSettings addonSettings) {
        super(settings, addonSettings);
    }
    
    @Override
    public @NotNull Class<? extends class_2586> getBlockEntityType() {
        return CombiAddonEntity.class;
    }
    
    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        
        if (!world.method_8608() && itemStack.method_57826(ComponentContent.ADDON_DATA.get()) && world.method_8321(pos) instanceof CombiAddonEntity combiAddonEntity) {
            combiAddonEntity.storedData = itemStack.method_57824(ComponentContent.ADDON_DATA.get());
        }
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        
        var showExtra = class_437.method_25441();
        
        if (showExtra) {
            
            if (!stack.method_57826(ComponentContent.ADDON_DATA.get())) return;
            
            var data = stack.method_57824(ComponentContent.ADDON_DATA.get());
            var foundTexts = getShrinkTooltip(data);
            
            tooltip.add(class_2561.method_43471("tooltip.oritech.combi_addon_desc").method_27692(class_124.field_1080));
            
            tooltip.addAll(foundTexts);
            
        }
    }
    
    public static @NotNull ArrayList<class_2561> getShrinkTooltip(ShrinkerBlockEntity.ShrunkAddonData data) {
        var usedSettings = data.data();
        var foundTexts = new ArrayList<class_2561>();
        
        if (usedSettings.speed() != 1) {
            var displayedNumber = Math.round((1 / usedSettings.speed() - 1) * 100);
            foundTexts.add(class_2561.method_43471("tooltip.oritech.addon_speed_desc").method_27692(class_124.field_1063)
                          .method_10852(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
        }
        
        if (usedSettings.efficiency() != 1) {
            var displayedNumber = Math.round((1 - usedSettings.efficiency()) * 100);
            foundTexts.add(class_2561.method_43471("tooltip.oritech.addon_efficiency_desc").method_27692(class_124.field_1063)
                          .method_10852(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
        }
        
        if (usedSettings.energyBonusCapacity() != 0) {
            foundTexts.add(
              class_2561.method_43471("tooltip.oritech.addon_capacity_desc").method_27692(class_124.field_1063)
                .method_10852(TooltipHelper.getFormattedEnergyChangeTooltip(usedSettings.energyBonusCapacity(), " RF")));
        }
        
        if (usedSettings.energyBonusTransfer() != 0) {
            foundTexts.add(class_2561.method_43471("tooltip.oritech.addon_transfer_desc").method_27692(class_124.field_1063)
                          .method_10852(TooltipHelper.getFormattedEnergyChangeTooltip(usedSettings.energyBonusTransfer(), " RF/t")));
        }
        
        if (usedSettings.maxBurstTicks() != 0) {
            foundTexts.add(class_2561.method_43469("tooltip.oritech.addon_combi_burst", usedSettings.maxBurstTicks()).method_27692(class_124.field_1080));
        }
        
        if (data.cropFilter()) {
            foundTexts.add(class_2561.method_43471("tooltip.oritech.addon_combi_crop").method_27692(class_124.field_1080));
        }
        
        if (data.fluid()) {
            foundTexts.add(class_2561.method_43471("tooltip.oritech.addon_combi_fluid").method_27692(class_124.field_1080));
        }
        
        if (data.quarryCount() > 0) {
            foundTexts.add(class_2561.method_43469("tooltip.oritech.addon_combi_quarry", data.quarryCount()).method_27692(class_124.field_1080));
        }
        if (data.yieldCount() > 0) {
            foundTexts.add(class_2561.method_43469("tooltip.oritech.addon_combi_yield", data.yieldCount()).method_27692(class_124.field_1080));
        }
        if (data.silk()) {
            foundTexts.add(class_2561.method_43471("tooltip.oritech.addon_combi_silk").method_27692(class_124.field_1080));
        }
        return foundTexts;
    }
}
