package rearth.oritech.block.blocks.pipes;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import java.util.HashSet;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5558;

public abstract class GenericPipeConnectionBlock extends GenericPipeBlock implements class_2343 {
    
    public GenericPipeConnectionBlock(class_2251 settings) {
        super(settings);
    }
    
    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_26204().equals(state.method_26204())) return;
        GenericPipeInterfaceEntity.addNode(world, pos, true, state, getNetworkData(world));
        
        var regKey = world.method_27983().method_29177();
        var dataId = getPipeTypeName() + "_" + regKey.method_12836() + "_" + regKey.method_12832();
        Oritech.LOGGER.debug("saving for: " + dataId);
        ((class_3218) world).method_17983().method_123(dataId, getNetworkData(world));
    }
    
    @Override
    protected void onBlockRemoved(class_2338 pos, class_2680 oldState, class_1937 world) {
        updateNeighbors(world, pos, false);
        GenericPipeInterfaceEntity.removeNode(world, pos, true, oldState, getNetworkData(world));
    }
    
    @Override
    public @NotNull class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        var worldImp = (class_1937) world;
        if (worldImp.field_9236) return state;
        
        if (state.method_11654(class_2741.field_12508))
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        
        if (!hasNeighboringMachine(state, worldImp, pos, false)) {
            // remove stale machine -> neighboring pipes mapping
            GenericPipeInterfaceEntity.removeStaleMachinePipeNeighbors(pos, getNetworkData(worldImp));
            
            var normalState = getNormalBlock();
            return ((GenericPipeBlock) normalState.method_26204()).addConnectionStates(normalState, worldImp, pos, false);
        }
        
        var interfaceState = state;
        if (!(neighborState.method_26204() instanceof AbstractPipeBlock)) {
            // only update connection if neighbor is a new machine
            var hasMachine = getNetworkData(worldImp).machinePipeNeighbors.getOrDefault(neighborPos, HashSet.newHashSet(0)).contains(direction.method_10153());
            if (neighborState.method_27852(class_2246.field_10124) || !hasMachine) {
                interfaceState = addConnectionStates(state, worldImp, pos, direction);
            }
            
            if (!interfaceState.equals(state)) {
                // reload connection when state has changed (e.g. machine added/removed)
                GenericPipeInterfaceEntity.addNode(worldImp, pos, true, interfaceState, getNetworkData(worldImp));
            }
        }
        
        return interfaceState;
    }
    
    @Override
    protected boolean toggleSideConnection(class_2680 state, class_2350 side, class_1937 world, class_2338 pos) {
        var property = directionToProperty(side);
        var createConnection = state.method_11654(property) == NO_CONNECTION;
        
        // check if connection would be valid if state is toggled
        var targetPos = pos.method_10093(side);
        if (createConnection && !isValidConnectionTarget(world.method_8320(targetPos).method_26204(), world, side.method_10153(), targetPos))
            return false;
        
        // toggle connection state
        int nextConnectionState = getNextConnectionState(state, side, world, pos, state.method_11654(property));
        var newState = addStraightState(state.method_11657(property, nextConnectionState));
        
        // transform to interface block if side is being enabled and machine is connected
        if (!hasNeighboringMachine(newState, world, pos, false)) {
            var normalBlock = (GenericPipeBlock) getNormalBlock().method_26204();
            var interfaceState = normalBlock.addConnectionStates(normalBlock.method_9564(), world, pos, false);
            interfaceState = interfaceState.method_11657(normalBlock.directionToProperty(side), newState.method_11654(property)); // Hacky way to copy connection state
            world.method_8501(pos, normalBlock.addStraightState(interfaceState));
        } else {
            world.method_8501(pos, newState);
            GenericPipeInterfaceEntity.addNode(world, pos, true, newState, getNetworkData(world));
            
            // update neighbor if it's a pipe
            updateNeighbors(world, pos, true);
        }
        
        // play sound
        var soundGroup = method_9573(state);
        world.method_8396(null, pos, soundGroup.method_10598(), class_3419.field_15245, soundGroup.method_10597() * .5f, soundGroup.method_10599());
        
        return true;
    }
    
    @SuppressWarnings("rawtypes")
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return new class_1799(getNormalBlock().method_26204());
    }
}
