/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.energy.containers;

import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

public class DynamicEnergyStorage
extends EnergyApi.EnergyStorage
implements UpdatableField<DynamicEnergyStorage, Long> {
    public long amount;
    public long capacity;
    public long maxInsert;
    public long maxExtract;
    private final Runnable onUpdate;
    private final boolean forceFullUpdate;
    public static final class_9139<ByteBuf, DynamicEnergyStorage> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_48551, DynamicEnergyStorage::getMaxExtract, (class_9139)class_9135.field_48551, DynamicEnergyStorage::getMaxInsert, (class_9139)class_9135.field_48551, DynamicEnergyStorage::getCapacity, (class_9139)class_9135.field_48551, DynamicEnergyStorage::getAmount, DynamicEnergyStorage::new);

    public DynamicEnergyStorage(long capacity, long maxInsert, long maxExtract, Runnable onUpdate) {
        this(capacity, maxInsert, maxExtract, onUpdate, false);
    }

    public DynamicEnergyStorage(long capacity, long maxInsert, long maxExtract, Runnable onUpdate, boolean alwaysFullUpdate) {
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
        this.onUpdate = onUpdate;
        this.forceFullUpdate = alwaysFullUpdate;
    }

    public DynamicEnergyStorage(long maxExtract, long maxInsert, long capacity, long amount) {
        this.maxExtract = maxExtract;
        this.maxInsert = maxInsert;
        this.capacity = capacity;
        this.amount = amount;
        this.forceFullUpdate = false;
        this.onUpdate = () -> {};
    }

    @Override
    public long insert(long amount, boolean simulate) {
        long inserted = Math.min(Math.min(this.maxInsert, amount), this.capacity - this.amount);
        if (!simulate) {
            this.amount += inserted;
        }
        return inserted;
    }

    public long insertIgnoringLimit(long amount, boolean simulate) {
        long inserted = Math.min(amount, this.capacity - this.amount);
        if (!simulate) {
            this.amount += inserted;
        }
        return inserted;
    }

    @Override
    public long extract(long amount, boolean simulate) {
        long extracted = Math.min(Math.min(amount, this.maxExtract), this.amount);
        if (!simulate) {
            this.amount -= extracted;
        }
        return extracted;
    }

    @Override
    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setMaxInsert(long maxInsert) {
        this.maxInsert = maxInsert;
    }

    public void setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public long getMaxInsert() {
        return this.maxInsert;
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    @Override
    public Long getDeltaData() {
        return this.amount;
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        if (this.forceFullUpdate) {
            return false;
        }
        return UpdatableField.super.useDeltaOnly(type);
    }

    @Override
    public DynamicEnergyStorage getFullData() {
        return this;
    }

    @Override
    public class_9139<? extends ByteBuf, Long> getDeltaCodec() {
        return class_9135.field_48551;
    }

    @Override
    public class_9139<? extends ByteBuf, DynamicEnergyStorage> getFullCodec() {
        return PACKET_CODEC;
    }

    @Override
    public void handleFullUpdate(DynamicEnergyStorage updatedData) {
        this.setAmount(updatedData.amount);
        this.setCapacity(updatedData.capacity);
        this.setMaxExtract(updatedData.maxExtract);
        this.setMaxInsert(updatedData.maxInsert);
    }

    @Override
    public void handleDeltaUpdate(Long updatedData) {
        this.setAmount(updatedData);
    }
}

