package rearth.oritech.block.base.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.util.MachineAddonController;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public abstract class FrameInteractionBlock extends class_2383 implements class_2343 {
    
    public static final class_2746 HAS_FRAME = class_2746.method_11825("has_frame");
    
    public FrameInteractionBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043).method_11657(HAS_FRAME, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12481, HAS_FRAME);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    
    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof FrameInteractionBlockEntity machineEntity)) {
                return class_1269.field_5812;
            }
            
            var frameValid = machineEntity.tryFindFrame();
            world.method_8501(pos, state.method_11657(HAS_FRAME, frameValid));
            
            if (frameValid) {
                if (entity instanceof MachineAddonController addonController)
                    addonController.initAddons();
                
                var handler = (ExtendedMenuProvider) world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222) player, handler);
            } else {
                player.method_43496(class_2561.method_43471("message.oritech.machine_frame.missing_frame"));
            }
            
        }
        return class_1269.field_5812;
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(HAS_FRAME)) {
            
            var ownEntity = (FrameInteractionBlockEntity) world.method_8321(pos);
            ownEntity.cleanup();
            
            if (ownEntity instanceof MachineAddonController machineEntity) {
                machineEntity.resetAddons();
            }
            
            if (ownEntity instanceof ItemEnergyFrameInteractionBlockEntity itemContainer) {
                var stacks = itemContainer.inventory.heldStacks;
                for (var stack : stacks) {
                    if (!stack.method_7960()) {
                        var itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
                        world.method_8649(itemEntity);
                    }
                }
                
                itemContainer.inventory.heldStacks.clear();
                itemContainer.inventory.method_5431();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        addMachineTooltip(tooltip, this, this);
    }
}
