/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.SmallFluidTank;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ApiLookupCache;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public class SmallTankEntity
extends NetworkedBlockEntity
implements FluidApi.BlockProvider,
ItemApi.BlockProvider,
ComparatorOutputProvider,
ScreenProvider,
ExtendedMenuProvider {
    private int lastComparatorOutput = 0;
    public final boolean isCreative;
    private ApiLookupCache<FluidApi.FluidStorage> downLookupCache;
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(3, this::method_5431, new InventorySlotAssignment(0, 2, 2, 1));
    @SyncField(value={SyncType.TICK, SyncType.INITIAL})
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage((long)Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount(), this::method_5431);

    public SmallTankEntity(class_2338 pos, class_2680 state, boolean isCreative) {
        super(isCreative ? BlockEntitiesContent.CREATIVE_TANK_ENTITY : BlockEntitiesContent.SMALL_TANK_ENTITY, pos, state);
        this.isCreative = isCreative;
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.method_5431();
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.isCreative) {
            if (this.fluidStorage.getFluid() != class_3612.field_15906) {
                this.fluidStorage.setAmount(this.fluidStorage.getCapacity() - FluidStackHooks.bucketAmount() * 8L);
            } else {
                this.fluidStorage.setAmount(0L);
            }
        }
        this.processInput();
        this.processOutput();
        if (this.fluidStorage.getAmount() > 0L) {
            this.outputToBelow();
        }
        this.updateComparators(world, pos, state);
    }

    private void outputToBelow() {
        FluidApi.FluidStorage tankCandidate;
        if (this.isCreative) {
            return;
        }
        if (this.downLookupCache == null) {
            this.downLookupCache = ApiLookupCache.create(this.field_11867.method_10074(), class_2350.field_11036, Objects.requireNonNull(this.field_11863), (world1, targetPos, targetState, targetEntity, direction) -> FluidApi.BLOCK.find(world1, targetPos, targetState, targetEntity, direction));
        }
        if (!((tankCandidate = this.downLookupCache.lookup()) instanceof SimpleFluidStorage)) {
            return;
        }
        SimpleFluidStorage belowTank = (SimpleFluidStorage)tankCandidate;
        SimpleFluidStorage ownTank = this.fluidStorage;
        SimpleFluidStorage.transfer(ownTank, belowTank, ownTank.getCapacity(), false);
    }

    private void updateComparators(class_1937 world, class_2338 pos, class_2680 state) {
        int previous = this.lastComparatorOutput;
        this.lastComparatorOutput = this.getComparatorOutput();
        if (previous != this.lastComparatorOutput) {
            world.method_8455(pos, state.method_26204());
        }
    }

    private void processInput() {
        boolean canFill;
        class_1799 inStack = this.inventory.method_5438(0);
        boolean bl = canFill = this.fluidStorage.getAmount() > 0L;
        if (!canFill || inStack.method_7960() || inStack.method_7947() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(inStack, updated -> this.inventory.method_5447(0, (class_1799)updated));
        FluidApi.FluidStorage candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsInsertion()) {
            return;
        }
        long moved = FluidApi.transferFirst(this.fluidStorage, candidate, FluidStackHooks.bucketAmount() * 64L, false);
        if (moved == 0L) {
            class_1799 outStack = this.inventory.method_5438(2);
            if (outStack.method_7960()) {
                this.inventory.method_5447(2, stackRef.getValue());
                this.inventory.method_5447(0, class_1799.field_8037);
            } else if (outStack.method_7909().equals(stackRef.getValue().method_7909()) && outStack.method_7947() < outStack.method_7914()) {
                outStack.method_7933(1);
                this.inventory.method_5447(0, class_1799.field_8037);
            }
        }
    }

    private void processOutput() {
        boolean canFill;
        class_1799 inStack = this.inventory.method_5438(1);
        boolean bl = canFill = this.fluidStorage.getAmount() < this.fluidStorage.getCapacity();
        if (!canFill || inStack.method_7960() || inStack.method_7947() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(inStack, updated -> this.inventory.method_5447(1, (class_1799)updated));
        FluidApi.FluidStorage candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsExtraction()) {
            return;
        }
        long moved = FluidApi.transferFirst(candidate, this.fluidStorage, FluidStackHooks.bucketAmount() * 64L, false);
        if (moved == 0L) {
            class_1799 outStack = this.inventory.method_5438(2);
            if (outStack.method_7960()) {
                this.inventory.method_5447(2, stackRef.getValue());
                this.inventory.method_5447(1, class_1799.field_8037);
            } else if (outStack.method_7909().equals(stackRef.getValue().method_7909()) && outStack.method_7947() < outStack.method_7914()) {
                outStack.method_7933(1);
                this.inventory.method_5447(1, class_1799.field_8037);
            }
        }
    }

    @Override
    public int getComparatorOutput() {
        if (this.fluidStorage.getFluid().equals(class_3612.field_15906)) {
            return 0;
        }
        float fillPercentage = (float)this.fluidStorage.getAmount() / (float)this.fluidStorage.getCapacity();
        return (int)(1.0f + fillPercentage * 14.0f);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && ((Boolean)this.method_11010().method_11654((class_2769)SmallFluidTank.LIT)).booleanValue() != this.isGlowingFluid()) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)SmallFluidTank.LIT, (Comparable)Boolean.valueOf(this.isGlowingFluid())));
        }
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 19), new ScreenProvider.GuiSlot(1, 50, 61), new ScreenProvider.GuiSlot(2, 130, 42, true));
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(70, 18, 21, 60);
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.TANK_SCREEN;
    }

    public boolean isGlowingFluid() {
        return this.fluidStorage.getAmount() > 0L && FluidStackHooks.getLuminosity((class_3611)this.fluidStorage.getFluid(), null, null) > 0;
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public ScreenProvider.ArrowConfiguration getIndicatorConfiguration() {
        return new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 95, 40, 29, 16, true);
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public FluidApi.SingleSlotStorage getFluidStorage(@Nullable class_2350 direction) {
        return this.fluidStorage;
    }
}

