package rearth.oritech.block.base.block;

import rearth.oritech.util.MultiblockMachineController;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;

import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3965;

public abstract class MultiblockFrameInteractionBlock extends FrameInteractionBlock {
    
    public MultiblockFrameInteractionBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(ASSEMBLED, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ASSEMBLED);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof MultiblockMachineController machineEntity)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = machineEntity.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = machineEntity.initMultiblock(state);
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            
            state = state.method_11657(ASSEMBLED, true);
        }
        
        return super.method_55766(state, world, pos, player, hit);
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(ASSEMBLED)) {
            
            var entity = world.method_8321(pos);
            if (entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
}
