/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.augmenter;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.OritechClient;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.TooltipHelper;

public class AugmentApplicationBlock
extends class_2383
implements class_2343 {
    private final class_265[] HITBOXES = this.computeShapes();
    private final HashMap<class_1657, Long> lastContact = new HashMap();
    public static class_3545<Long, class_1657> lastTeleportedPlayer;

    public AugmentApplicationBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!((Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return super.method_9530(state, world, pos, context);
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        return this.HITBOXES[facing.ordinal()];
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481, MultiblockMachine.ASSEMBLED});
    }

    private class_265[] computeShapes() {
        class_265[] result = new class_265[6];
        for (class_2350 facing : class_2741.field_12481.method_11898()) {
            result[facing.ordinal()] = class_259.method_1084((class_265)Geometry.rotateVoxelShape(class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), facing, class_2738.field_12475), (class_265)Geometry.rotateVoxelShape(class_259.method_1081((double)0.0, (double)0.1875, (double)0.875, (double)1.0, (double)1.0, (double)1.0), facing, class_2738.field_12475));
        }
        return result;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042().method_10153());
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        long age;
        if (world.field_9236 || !((Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (lastTeleportedPlayer != null && (age = world.method_8510() - (Long)lastTeleportedPlayer.method_15442()) < 20L) {
            return;
        }
        class_243 centerPos = pos.method_61082().method_1031(0.0, 0.2, 0.0);
        double dist = entity.method_19538().method_1022(centerPos);
        if (dist < 0.45) {
            boolean locked;
            long ageWithoutContact = world.method_8510() - this.lastContact.getOrDefault(player, 0L);
            long time = world.method_8510();
            this.lastContact.put(player, time);
            if (ageWithoutContact > 15L && (locked = this.lockPlayer(player, centerPos, state))) {
                AugmentApplicationEntity blockEntity = (AugmentApplicationEntity)world.method_8321(pos);
                blockEntity.loadAvailableStations(player);
                ExtendedMenuProvider handler = (ExtendedMenuProvider)world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)handler);
            }
        }
    }

    private boolean lockPlayer(class_1657 player, class_243 lockPos, class_2680 state) {
        double maxVelocity = Math.max(Math.max(Math.abs(player.method_18798().field_1352), Math.abs(player.method_18798().field_1351)), Math.abs(player.method_18798().field_1350));
        if (maxVelocity < 0.01 || player.field_7512 instanceof PlayerModifierScreenHandler) {
            return false;
        }
        player.method_37908().method_45447(null, player.method_24515(), class_3417.field_14675, class_3419.field_15245);
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        int rotation = switch (facing) {
            case class_2350.field_11043 -> 180;
            case class_2350.field_11039 -> 90;
            case class_2350.field_11034 -> -90;
            default -> 0;
        };
        player.method_18799(class_243.field_1353);
        player.method_48105((class_3218)player.method_37908(), lockPos.field_1352, lockPos.field_1351, lockPos.field_1350, Set.of(), (float)rotation, 0.0f);
        double dist = player.method_19538().method_1022(lockPos);
        return dist < 0.1;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        Boolean corePlaced;
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof AugmentApplicationEntity)) {
            return class_1269.field_5812;
        }
        AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
        Boolean wasAssembled = (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
        if (!wasAssembled.booleanValue() && (corePlaced = modifierEntity.tryPlaceNextCore(player)).booleanValue()) {
            return class_1269.field_5812;
        }
        boolean isAssembled = modifierEntity.initMultiblock(state);
        if (isAssembled && !wasAssembled.booleanValue()) {
            modifierEntity.triggerSetupAnimation();
            return class_1269.field_5812;
        }
        if (!isAssembled) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.machine.missing_core"));
            return class_1269.field_5812;
        }
        AugmentApplicationEntity blockEntity = (AugmentApplicationEntity)world.method_8321(pos);
        blockEntity.loadAvailableStations(player);
        ExtendedMenuProvider handler = (ExtendedMenuProvider)world.method_8321(pos);
        MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)handler);
        return class_1269.field_5812;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 entity;
        if (!world.method_8608() && (entity = world.method_8321(pos)) instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity storageBlock = (AugmentApplicationEntity)entity;
            storageBlock.onControllerBroken();
            class_2371<class_1799> stacks = storageBlock.inventory.heldStacks;
            for (class_1799 heldStack : stacks) {
                if (heldStack.method_7960()) continue;
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), heldStack);
                world.method_8649((class_1297)itemEntity);
            }
            storageBlock.inventory.heldStacks.clear();
            storageBlock.inventory.method_5431();
        }
        return super.method_9576(world, pos, state, player);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AugmentApplicationEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558) {
                class_5558 ticker = (class_5558)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        class_2561 hotkey = OritechClient.AUGMENT_SELECTOR.field_1655.method_27445();
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.augmenter.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.oritech.augmenter.2", (Object[])new Object[]{hotkey.method_54160()}).method_27692(class_124.field_1080));
        TooltipHelper.addMachineTooltip(tooltip, (class_2248)this, this);
    }
}

