package rearth.oritech.init;

import com.mojang.serialization.codecs.PrimitiveCodec;
import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import rearth.oritech.Oritech;

import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9331;

// this can't be an auto container because as always, neoforge is annoying
// because of stupid neoforge we have to register components separately there, because $REASONS
// when adding/changing this, make sure to update the components in the neo entry class aswell
@SuppressWarnings("unchecked")
public class ComponentContent {
    
    public static final DeferredRegister<class_9331<?>> COMPONENTS = DeferredRegister.create(Oritech.MOD_ID, class_7924.field_49659);
    
    public static final RegistrySupplier<class_9331<Boolean>> IS_AOE_ACTIVE_REG = COMPONENTS.register("is_aoe_active", () -> class_9331.<Boolean>method_57873().method_57881(PrimitiveCodec.BOOL).method_57882(class_9135.field_48547).method_57880());
    public static final RegistrySupplier<class_9331<class_2338>> TARGET_POSITION_REG = COMPONENTS.register("target_position", () -> class_9331.<class_2338>method_57873().method_57881(class_2338.field_25064).method_57882(class_2338.field_48404).method_57880());
    public static final RegistrySupplier<class_9331<FluidStack>> STORED_FLUID_REG = COMPONENTS.register("stored_fluid", () -> class_9331.<FluidStack>method_57873().method_57881(FluidStack.CODEC).method_57882(FluidStack.STREAM_CODEC).method_57880());

    public static final Supplier<class_9331<Boolean>> IS_AOE_ACTIVE = () -> (class_9331<Boolean>) class_7923.field_49658.method_10223(Oritech.id("is_aoe_active"));
    public static final Supplier<class_9331<class_2338>> TARGET_POSITION = () -> (class_9331<class_2338>) class_7923.field_49658.method_10223(Oritech.id("target_position"));
    public static final Supplier<class_9331<FluidStack>> STORED_FLUID = () -> (class_9331<FluidStack>) class_7923.field_49658.method_10223(Oritech.id("stored_fluid"));
    
    // because I can't seem to find a default component for this on neoforge
    public static final Supplier<class_9331<Long>> NEO_ENERGY_COMPONENT = () -> (class_9331<Long>) class_7923.field_49658.method_10223(Oritech.id("energy"));
    
    public static void registerComponents() {
        COMPONENTS.register();
    }
    
}
