/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.client.ui.InventoryProxyScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonController;

public class InventoryProxyAddonBlockEntity
extends AddonBlockEntity
implements ItemApi.BlockProvider,
ExtendedMenuProvider {
    private MachineAddonController cachedController;
    private int targetSlot = 0;
    private final DelegatingInventoryStorage inventory = new DelegatingInventoryStorage(this::getTargetItemStorage, this::isConnected){

        @Override
        public int insert(class_1799 inserted, boolean simulate) {
            return this.insertToSlot(inserted, InventoryProxyAddonBlockEntity.this.targetSlot, simulate);
        }

        @Override
        public int extract(class_1799 extracted, boolean simulate) {
            return this.extractFromSlot(extracted, InventoryProxyAddonBlockEntity.this.targetSlot, simulate);
        }

        @Override
        public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
            if (slot != InventoryProxyAddonBlockEntity.this.targetSlot) {
                return 0;
            }
            return super.insertToSlot(inserted, slot, simulate);
        }

        @Override
        public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
            if (slot != InventoryProxyAddonBlockEntity.this.targetSlot) {
                return 0;
            }
            return super.extractFromSlot(extracted, slot, simulate);
        }
    };

    public InventoryProxyAddonBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.INVENTORY_PROXY_ADDON_ENTITY, pos, state);
    }

    private ItemApi.InventoryStorage getTargetItemStorage() {
        Boolean isUsed = (Boolean)this.method_11010().method_11654((class_2769)MachineAddonBlock.ADDON_USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MachineAddonController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof ItemApi.BlockProvider)) {
            return null;
        }
        ItemApi.BlockProvider itemProvider = (ItemApi.BlockProvider)((Object)controllerEntity);
        return itemProvider.getInventoryStorage(null);
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.method_11010().method_11654((class_2769)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    private MachineAddonController getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        this.cachedController = (MachineAddonController)Objects.requireNonNull(this.field_11863).method_8321(this.getControllerPos());
        return this.cachedController;
    }

    public void saveExtraData(class_2540 buf) {
        InventoryProxyScreenHandler.InvProxyData data = new InventoryProxyScreenHandler.InvProxyData(this.field_11867, this.getControllerPos(), this.targetSlot);
        InventoryProxyScreenHandler.InvProxyData.PACKET_CODEC.encode((Object)buf, (Object)data);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"title.oritech.inventory_proxy");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new InventoryProxyScreenHandler(syncId, playerInventory, this, this.getCachedController().getScreenProvider(), this.targetSlot);
    }

    public void setTargetSlot(int targetSlot) {
        this.targetSlot = targetSlot;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("target_slot", this.targetSlot);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.targetSlot = nbt.method_10550("target_slot");
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    public static void receiveSlotSelection(InventoryProxySlotSelectorPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = player.method_37908().method_8321(packet.position);
        if (class_25862 instanceof InventoryProxyAddonBlockEntity) {
            InventoryProxyAddonBlockEntity addonBlock = (InventoryProxyAddonBlockEntity)class_25862;
            addonBlock.setTargetSlot(packet.slot);
        }
    }

    public record InventoryProxySlotSelectorPacket(class_2338 position, int slot) implements class_8710
    {
        public static final class_8710.class_9154<InventoryProxySlotSelectorPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("proxy_slot_sel"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

