package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.registry.EmiRecipeFiller;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreenHandler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class EmiTransferHandler<S extends BasicMachineScreenHandler> implements StandardRecipeHandler<S> {
    
    private final class_2960 categoryId;
    
    public EmiTransferHandler(class_2960 categoryId) {
        this.categoryId = categoryId;
    }
    
    @Override
    public List<class_1735> getInputSources(S handler) {
        return handler.field_7761;
    }
    
    @Override
    public List<class_1735> getCraftingSlots(S handler) {
        
        if (!(handler.blockEntity instanceof MachineBlockEntity machine)) return List.of();
        
        var res = new ArrayList<class_1735>();
        
        for (int i = handler.getMachineInvStartSlot(class_1799.field_8037); i < handler.getMachineInvStartSlot(class_1799.field_8037) + machine.getSlotAssignments().inputCount(); i++) {
            res.add(handler.field_7761.get(i));
        }
        
        return res;
        
    }
    
    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        
        if (!(recipe instanceof OritechEMIRecipe oriRecipe)) return false;
        
        var id = oriRecipe.getCategory().getId();
        return id.equals(categoryId);
    }
    
    @Override
    public boolean craft(EmiRecipe recipe, EmiCraftContext<S> context) {
        
        var stacks = EmiRecipeFiller.getStacks(this, recipe, context.getScreen(), context.getAmount());
        if (stacks != null) {
            return EmiRecipeFiller.clientFill(this, recipe, context.getScreen(), stacks, context.getDestination());
        }
        return false;
    }
    
    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<S> context) {
        
        var handler = context.getScreenHandler();
        if (getCraftingSlots(handler).stream().anyMatch(slot -> slot.method_7681() && !slot.method_7677().method_7960())) // check if a non-empty slot is present
            return false;
        
        return StandardRecipeHandler.super.canCraft(recipe, context);
    }
}
