package rearth.oritech.block.blocks.pipes.energy;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import rearth.oritech.block.blocks.pipes.GenericPipeDuctBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

public class SuperConductorDuctBlock extends GenericPipeDuctBlock {
	public SuperConductorDuctBlock(class_2251 settings) {
		super(settings);
	}

	@Override
	public class_2680 getConnectionBlock() {
		return getNormalBlock();
	}

	@Override
	public class_2680 getNormalBlock() {
		return BlockContent.SUPERCONDUCTOR_DUCT_BLOCK.method_9564();
	}

	@Override
	public String getPipeTypeName() {
		return "superconductor";
	}

	@Override
	public boolean connectToOwnBlockType(class_2248 block) {
		return block instanceof SuperConductorDuctBlock || block instanceof SuperConductorBlock || block instanceof SuperConductorConnectionBlock;
	}

	@Override
	public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(class_1937 world) {
		return SuperConductorBlock.SUPERCONDUCTOR_DATA.computeIfAbsent(world.method_27983().method_29177(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
	}
}
