package rearth.oritech.item.tools.harvesting;

import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9424.class_9425;

public class ChainsawItem extends class_1743 implements OritechEnergyItem {
    
    public static final int BAR_STEP_COUNT = 13;
    private final float energyUsageMultiplier = Oritech.CONFIG.chainSaw.energyUsage();
    
    public ChainsawItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        // a bit of a hack, but set tool components again after super()
        // this lets ChainsawItem extend AxeItem (for the right-click actions) and still ignore
        // the default tool components set up by AxeItem
        var toolComponent = new class_9424(List.of(
            class_9425.method_58427(toolMaterial.method_58419()),
            class_9425.method_58428(class_3481.field_33713, toolMaterial.method_8027()),
            class_9425.method_58433(class_3481.field_44469, 1.5F),
            class_9425.method_58431(List.of(class_2246.field_10343), 15.0F)),
            1.0F, 1);
        this.field_49263 = settings.method_57349(class_9334.field_50077, toolComponent).method_58406();
    }
    
    // this overrides the fabric specific extensions
    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }
    
    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }
    
    // this overrides the neoforge specific extensions
    public boolean shouldCauseReequipAnimation(@NotNull class_1799 oldStack, @NotNull class_1799 newStack, boolean slotChanged) {
        return false;
    }
    
    public boolean shouldCauseBlockBreakReset(@NotNull class_1799 oldStack, @NotNull class_1799 newStack) {
        return false;
    }
    
    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        
        if (!(miner instanceof class_1657 player)) return true;
        
        var amount = state.method_26204().method_36555() * energyUsageMultiplier;
        amount = Math.min(amount, this.getStoredEnergy(stack));
        
        var energySuccess = this.tryUseEnergy(stack, (long) amount, player);
        
        if (!world.field_9236 && miner.method_5715() && energySuccess && Oritech.CONFIG.chainsawTreeCutting()) {
            var startPos = pos.method_10084();
            var startState = world.method_8320(startPos);
            if (startState.method_26164(class_3481.field_15475)) {
                var treeBlocks = TreefellerBlockEntity.getTreeBlocks(startPos, world);
                PromethiumAxeItem.pendingBlocks.addAll(treeBlocks.stream().map(elem -> new class_3545<>(world, elem)).toList());
                
                var extraEnergyUsed = treeBlocks.size() * energyUsageMultiplier / 2;
                this.tryUseEnergy(stack, (long) extraEnergyUsed, player);
            }
        }
        
        return energySuccess;
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var text = class_2561.method_43469("tooltip.oritech.energy_indicator", this.getStoredEnergy(stack), this.getEnergyCapacity(stack));
        tooltip.add(text.method_27692(class_124.field_1065));
        
        if (Oritech.CONFIG.chainsawTreeCutting())
            tooltip.add(class_2561.method_43471("tooltip.oritech.promethium_axe").method_27692(class_124.field_1063));
    }
    
    @Override
    public float method_58404(class_1799 stack, class_2680 state) {
        var enoughEnergy = getStoredEnergy(stack) >= state.method_26204().method_36555() * energyUsageMultiplier;
        var multiplier = enoughEnergy ? 1 : 0.1f;
        return super.method_58404(stack, state) * multiplier;
    }
    
    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
    
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        return Math.round((getStoredEnergy(stack) * 100f / this.getEnergyCapacity(stack)) * BAR_STEP_COUNT) / 100;
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return 0xff7007;
    }
    
    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.chainSaw.energyCapacity();
    }
    
    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.chainSaw.chargeSpeed();
    }
}
