package rearth.oritech.init.compat.jei;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;

public class OritechJeiParticleCollisionRecipe implements IRecipeCategory<OritechRecipe> {
    
    public final OritechRecipeType type;
    public final IDrawable icon;
    public final IDrawableAnimated arrow;
    public final IDrawableStatic background;
    
    public OritechJeiParticleCollisionRecipe(IGuiHelper helper) {
        this.type = RecipeContent.PARTICLE_COLLISION;
        this.icon = helper.createDrawableItemStack(new class_1799(BlockContent.ACCELERATOR_CONTROLLER.method_8389()));
        
        this.arrow = helper.createAnimatedRecipeArrow(40);
        this.background = helper.getSlotDrawable();
        
    }
    
    @Override
    public @NotNull RecipeType<OritechRecipe> getRecipeType() {
        return RecipeType.create(type.getIdentifier().method_12836(), type.getIdentifier().method_12832(), OritechRecipe.class);
    }
    
    @Override
    public @NotNull class_2561 getTitle() {
        return class_2561.method_43471("emi.category.oritech." + type.getIdentifier().method_12832());
    }
    
    @Override
    public @Nullable IDrawable getIcon() {
        return icon;
    }
    
    @Override
    public int getWidth() {
        return 170;
    }
    
    @Override
    public int getHeight() {
        return 66;
    }
    
    @Override
    public void draw(OritechRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        
        arrow.draw(guiGraphics, 80 - 23, 41 - 17);
        
        // data
        guiGraphics.method_27535(class_310.method_1551().field_1772, class_2561.method_43469("emi.title.oritech.collisionspeed", recipe.getTime()), 2, (int) (getHeight() * 0.88), 0xffffff);
        
    }
    
    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, OritechRecipe recipe, IFocusGroup focuses) {
        
        var inputs = recipe.getInputs();
        
        builder.addInputSlot(25, 10).addIngredients(inputs.get(0)).setBackground(background, -1, -1);
        builder.addInputSlot(25, 33).addIngredients(inputs.get(1)).setBackground(background, -1, -1);
        builder.addOutputSlot(90, 24).addItemStack(recipe.getResults().get(0)).setBackground(background, -1, -1);
    }
}
