package rearth.oritech.block.blocks.storage;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.entity.storage.LargeStorageBlockEntity;
import rearth.oritech.util.MultiblockMachineController;

import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;


public class LargeStorageBlock extends SmallStorageBlock {
    
    public LargeStorageBlock(class_2251 settings) {
        super(settings.method_9631(value -> 2));
        method_9590(method_9564().method_11657(ASSEMBLED, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ASSEMBLED);
    }
    
    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LargeStorageBlockEntity(pos, state);
    }
    
    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(TARGET_DIR, ctx.method_8042().method_10153());
    }
    
    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return new class_1799(this);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof MultiblockMachineController machineEntity)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = machineEntity.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = machineEntity.initMultiblock(state);
            
            // first time created
            if (isAssembled && !wasAssembled) {
                // NetworkContent.MACHINE_CHANNEL.serverHandle(machineEntity).send(new NetworkContent.MachineSetupEventPacket(pos));
                return class_1269.field_5812;
            }
            
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            
        }
        
        return super.method_55766(state, world, pos, player, hit);
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(ASSEMBLED)) {
            
            var entity = world.method_8321(pos);
            if (entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
            
            if (entity instanceof ExpandableEnergyStorageBlockEntity storageBlock) {
                var stacks = storageBlock.inventory.heldStacks;
                for (var heldStack : stacks) {
                    if (!heldStack.method_7960()) {
                        var itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), heldStack);
                        world.method_8649(itemEntity);
                    }
                }
                
                storageBlock.inventory.heldStacks.clear();
                storageBlock.inventory.method_5431();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
}