/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.ItemFilterScreenHandler;

public class ItemFilterScreen
extends BaseOwoHandledScreen<FlowLayout, ItemFilterScreenHandler> {
    public static final int FILTER_SIZE = 12;
    private ButtonComponent whiteListButton;
    private ButtonComponent nbtButton;
    private ButtonComponent componentButton;
    private final FlowLayout[] gridContainers = new FlowLayout[12];
    private Map<Integer, class_1799> cachedItems;

    public ItemFilterScreen(ItemFilterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    public void updateItemFilters() {
        this.cachedItems = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings().items();
        Oritech.LOGGER.debug("loading item filters: " + String.valueOf(this.cachedItems));
        for (int i = 0; i < 12; ++i) {
            class_1799 storedStack = this.cachedItems.getOrDefault(i, class_1799.field_8037);
            FlowLayout container = this.gridContainers[i];
            if (container.children().size() == 2) {
                container.removeChild((Component)container.children().get(1));
            }
            if (storedStack.method_7960()) continue;
            ItemComponent itemComponent = Components.item((class_1799)storedStack);
            itemComponent.positioning(Positioning.absolute((int)1, (int)1));
            itemComponent.showOverlay(true);
            itemComponent.setTooltipFromStack(true);
            container.child((Component)itemComponent);
        }
    }

    private void updateButtons() {
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings();
        class_5250 textWhitelistTooltip = data.useWhitelist() ? class_2561.method_43471((String)"tooltip.oritech.item_filter.whitelist") : class_2561.method_43471((String)"tooltip.oritech.item_filter.blacklist");
        class_5250 textNbtTooltip = data.useNbt() ? class_2561.method_43471((String)"tooltip.oritech.item_filter.nbt") : class_2561.method_43471((String)"tooltip.oritech.item_filter.no_nbt");
        class_5250 textNbtComponent = data.useComponents() ? class_2561.method_43471((String)"tooltip.oritech.item_filter.component") : class_2561.method_43471((String)"tooltip.oritech.item_filter.no_component");
        this.whiteListButton.tooltip((class_2561)textWhitelistTooltip);
        this.nbtButton.tooltip((class_2561)textNbtTooltip);
        this.componentButton.tooltip((class_2561)textNbtComponent);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)166));
        GridLayout gridContainer = Containers.grid((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0), (int)3, (int)4);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 3; ++y) {
                FlowLayout slotContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)18), (Sizing)Sizing.fixed((int)18));
                BaseComponent background = Components.texture((class_2960)BasicMachineScreen.ITEM_SLOT, (int)0, (int)0, (int)18, (int)18, (int)18, (int)18).positioning(Positioning.absolute((int)0, (int)0));
                int finalX = x;
                int finalY = y;
                background.mouseDown().subscribe((mouseX, mouseY, button) -> this.onItemFrameBackgroundClicked(slotContainer, finalX, finalY));
                slotContainer.child((Component)background);
                int idIndex = y * 4 + x;
                this.gridContainers[idIndex] = slotContainer;
                gridContainer.child((Component)slotContainer.margins(Insets.of((int)0, (int)2, (int)0, (int)1)), y, x);
            }
        }
        overlay.child((Component)gridContainer.positioning(Positioning.absolute((int)5, (int)18)));
        int buttonWidth = 60;
        this.whiteListButton = Components.button((class_2561)class_2561.method_43470((String)"            ").method_10852((class_2561)class_2561.method_43471((String)"title.oritech.item_filter.whitelist").method_54663(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> this.toggleWhitelist());
        this.whiteListButton.horizontalSizing(Sizing.fixed((int)buttonWidth));
        this.whiteListButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings().useWhitelist()));
        this.whiteListButton.textShadow(false);
        overlay.child(this.whiteListButton.positioning(Positioning.absolute((int)83, (int)18)));
        this.nbtButton = Components.button((class_2561)class_2561.method_43470((String)"      ").method_10852((class_2561)class_2561.method_43471((String)"title.oritech.item_filter.nbt").method_54663(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> this.toggleNbt());
        this.nbtButton.horizontalSizing(Sizing.fixed((int)buttonWidth));
        this.nbtButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings().useNbt()));
        this.nbtButton.textShadow(false);
        overlay.child(this.nbtButton.positioning(Positioning.absolute((int)83, (int)38)));
        this.componentButton = Components.button((class_2561)class_2561.method_43470((String)"                ").method_10852((class_2561)class_2561.method_43471((String)"title.oritech.item_filter.component").method_54663(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> this.toggleComponent());
        this.componentButton.horizontalSizing(Sizing.fixed((int)buttonWidth));
        this.componentButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings().useComponents()));
        this.componentButton.textShadow(false);
        overlay.child(this.componentButton.positioning(Positioning.absolute((int)83, (int)58)));
        this.addTitle(overlay);
        rootComponent.child((Component)Components.texture((class_2960)BasicMachineScreen.BACKGROUND, (int)0, (int)0, (int)176, (int)166, (int)176, (int)166)).child((Component)overlay.positioning(Positioning.relative((int)50, (int)50)));
        this.updateButtons();
        this.updateItemFilters();
    }

    public static ButtonComponent.Renderer createToggleRenderer(Predicate<ButtonComponent> activeSupplier) {
        return (owoUIDrawContext, button, v) -> {
            RenderSystem.enableDepthTest();
            boolean isOn = activeSupplier.test(button);
            class_2960 normalTexture = isOn ? Oritech.id("textures/gui/modular/toggle_on.png") : Oritech.id("textures/gui/modular/toggle_off.png");
            class_2960 hoverTexture = isOn ? Oritech.id("textures/gui/modular/toggle_on_hover.png") : Oritech.id("textures/gui/modular/toggle_off_hover.png");
            owoUIDrawContext.method_25293(button.method_49606() ? hoverTexture : normalTexture, button.x(), button.y(), 30, 16, 0.0f, 0.0f, 30, 16, 30, 16);
        };
    }

    private void addTitle(FlowLayout overlay) {
        class_5250 blockTitle = ((ItemFilterScreenHandler)this.field_2797).blockEntity.method_11010().method_26204().method_9518();
        LabelComponent label = Components.label((class_2561)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((Component)label.positioning(Positioning.relative((int)50, (int)2)));
    }

    private void sendUpdateToServer() {
        NetworkManager.sendToServer(new ItemFilterBlockEntity.ItemFilterPayload(((ItemFilterScreenHandler)this.field_2797).blockPos, ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings()));
    }

    private void toggleWhitelist() {
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings();
        boolean whitelist = data.useWhitelist();
        boolean newWhitelist = !whitelist;
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(data.useNbt(), newWhitelist, data.useComponents(), data.items());
        this.updateFilterSettings(newData);
        this.updateButtons();
        this.sendUpdateToServer();
    }

    private void toggleNbt() {
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings();
        boolean nbt = data.useNbt();
        boolean newNbt = !nbt;
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(newNbt, data.useWhitelist(), data.useComponents(), data.items());
        this.updateFilterSettings(newData);
        this.updateButtons();
        this.sendUpdateToServer();
    }

    private void toggleComponent() {
        boolean newComponent;
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings();
        boolean component = data.useComponents();
        boolean nbt = data.useNbt();
        boolean bl = newComponent = !component;
        if (newComponent) {
            nbt = true;
        }
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(nbt, data.useWhitelist(), newComponent, data.items());
        this.updateFilterSettings(newData);
        this.updateButtons();
        this.sendUpdateToServer();
    }

    private boolean onItemFrameBackgroundClicked(FlowLayout slotContainer, int x, int y) {
        return this.acceptItemStack(slotContainer, ((ItemFilterScreenHandler)this.field_2797).method_34255(), y * 4 + x);
    }

    public boolean acceptItemStack(class_1799 itemStack, int index) {
        return this.acceptItemStack(this.getItemContainer(index), itemStack, index);
    }

    public boolean acceptItemStack(FlowLayout slotContainer, class_1799 itemStack, int index) {
        if (slotContainer.children().size() >= 2) {
            slotContainer.removeChild((Component)slotContainer.children().get(1));
        }
        if (itemStack.method_7960()) {
            ItemFilterBlockEntity.FilterData oldData = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings();
            HashMap<Integer, class_1799> itemFilters = new HashMap<Integer, class_1799>(oldData.items());
            itemFilters.remove(index);
            ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(oldData.useNbt(), oldData.useWhitelist(), oldData.useComponents(), itemFilters);
            this.updateFilterSettings(newData);
            this.sendUpdateToServer();
            return false;
        }
        class_1799 displayStack = new class_1799((class_1935)itemStack.method_7909(), 1);
        if (itemStack.method_57353() != null) {
            displayStack.method_57365(itemStack.method_57353());
        }
        ItemComponent itemComponent = Components.item((class_1799)displayStack);
        itemComponent.positioning(Positioning.absolute((int)1, (int)1));
        itemComponent.showOverlay(true);
        itemComponent.setTooltipFromStack(true);
        slotContainer.child((Component)itemComponent);
        ItemFilterBlockEntity.FilterData oldData = ((ItemFilterScreenHandler)this.field_2797).blockEntity.getFilterSettings();
        HashMap<Integer, class_1799> itemFilters = new HashMap<Integer, class_1799>(oldData.items());
        itemFilters.put(index, displayStack);
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(oldData.useNbt(), oldData.useWhitelist(), oldData.useComponents(), itemFilters);
        this.updateFilterSettings(newData);
        Oritech.LOGGER.debug("stored map: " + String.valueOf(itemFilters));
        this.sendUpdateToServer();
        return true;
    }

    public FlowLayout getItemContainer(int index) {
        return this.gridContainers[index];
    }

    private void updateFilterSettings(ItemFilterBlockEntity.FilterData filterData) {
        ((ItemFilterScreenHandler)this.field_2797).blockEntity.setFilterSettings(filterData);
        this.cachedItems = filterData.items();
    }
}

