/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.behavior;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.TagContent;

public class LaserArmBlockBehavior {
    private static LaserArmBlockBehavior noop;
    private static LaserArmBlockBehavior transferPowerBehavior;
    private static LaserArmBlockBehavior energizeBuddingBehavior;

    public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (laserEntity.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(blockState)) {
            return false;
        }
        EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, blockEntity, null);
        if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider) {
            EnergyApi.BlockProvider provider = (EnergyApi.BlockProvider)blockEntity;
            storageCandidate = provider.getEnergyStorage(null);
        }
        if (storageCandidate != null) {
            return transferPowerBehavior.fireAtBlock(world, laserEntity, block, blockPos, blockState, blockEntity);
        }
        if (blockState.method_26164(TagContent.LASER_ACCELERATED)) {
            return energizeBuddingBehavior.fireAtBlock(world, laserEntity, block, blockPos, blockState, blockEntity);
        }
        if (blockState.method_26164(TagContent.LASER_PASSTHROUGH)) {
            return false;
        }
        laserEntity.addBlockBreakProgress(laserEntity.energyRequiredToFire());
        if (laserEntity.getBlockBreakProgress() >= laserEntity.getTargetBlockEnergyNeeded()) {
            laserEntity.finishBlockBreaking(blockPos, blockState);
        }
        return true;
    }

    public static void registerDefaults() {
        noop = new LaserArmBlockBehavior(){

            @Override
            public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
                return false;
            }
        };
        LaserArmBlock.registerBlockBehavior(class_2246.field_22422, noop);
        LaserArmBlock.registerBlockBehavior(class_2246.field_9987, noop);
        transferPowerBehavior = new LaserArmBlockBehavior(){

            @Override
            public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
                long insertAmount;
                EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, blockEntity, null);
                if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider) {
                    EnergyApi.BlockProvider energyProvider = (EnergyApi.BlockProvider)blockEntity;
                    storageCandidate = energyProvider.getEnergyStorage(null);
                }
                if (blockEntity instanceof UnstableContainerBlockEntity) {
                    UnstableContainerBlockEntity unstableContainerBlockEntity = (UnstableContainerBlockEntity)blockEntity;
                    storageCandidate = unstableContainerBlockEntity.laserInputStorage;
                }
                if ((insertAmount = storageCandidate.getCapacity() - storageCandidate.getAmount()) <= 0L) {
                    return false;
                }
                long transferCapacity = Math.min(insertAmount, (long)laserEntity.energyRequiredToFire());
                if (storageCandidate instanceof DynamicEnergyStorage) {
                    DynamicEnergyStorage dynamicStorage = (DynamicEnergyStorage)storageCandidate;
                    long inserted = dynamicStorage.insertIgnoringLimit(transferCapacity, true);
                    if (inserted > 0L && inserted <= transferCapacity) {
                        dynamicStorage.insertIgnoringLimit(transferCapacity, false);
                        dynamicStorage.update();
                        if (blockEntity instanceof AtomicForgeBlockEntity) {
                            AtomicForgeBlockEntity atomicForgeBlock = (AtomicForgeBlockEntity)blockEntity;
                            atomicForgeBlock.lastWorkedAt = world.method_8510();
                        }
                        return true;
                    }
                    return false;
                }
                long inserted = storageCandidate.insert(transferCapacity, true);
                if (inserted > 0L && inserted <= transferCapacity) {
                    storageCandidate.insert(transferCapacity, false);
                    storageCandidate.update();
                    return true;
                }
                return false;
            }
        };
        LaserArmBlock.registerBlockBehavior(BlockContent.ATOMIC_FORGE_BLOCK, transferPowerBehavior);
        LaserArmBlock.registerBlockBehavior(BlockContent.DEEP_DRILL_BLOCK, transferPowerBehavior);
        LaserArmBlock.registerBlockBehavior(BlockContent.ENCHANTMENT_CATALYST_BLOCK, transferPowerBehavior);
        energizeBuddingBehavior = new LaserArmBlockBehavior(){

            @Override
            public boolean fireAtBlock(class_1937 world, LaserArmBlockEntity laserEntity, class_2248 block, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
                if (world.method_8510() % 40L == 0L) {
                    return false;
                }
                if (blockState.method_26215() || blockState.method_26227().method_15771()) {
                    return false;
                }
                blockState.method_26199((class_3218)world, blockPos, world.field_9229);
                ParticleContent.ACCELERATING.spawn(world, class_243.method_24954((class_2382)blockPos));
                return true;
            }
        };
        LaserArmBlock.registerBlockBehavior(class_2246.field_27160, energizeBuddingBehavior);
    }
}

