package rearth.oritech.init;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.registries.RegistrySupplier;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.init.ItemContent.Groups;
import rearth.oritech.item.tools.ElectricMaceItem;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.armor.*;
import rearth.oritech.item.tools.harvesting.*;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.registry.ArchitecturyRegistryContainer;

import java.lang.reflect.Field;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_2378;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_9300;
import net.minecraft.class_9334;

public class ToolsContent implements ArchitecturyRegistryContainer<class_1792> {
    
    protected static final class_1792.class_1793 UNBREAKING_SETTINGS = new class_1792.class_1793()
                                                               .method_7889(1)
                                                               .method_7895(0)
                                                               .method_57349(class_9334.field_49630, new class_9300(true));
    
    protected static final class_1792.class_1793 ELECTRIC_SETTINGS = UNBREAKING_SETTINGS; //.component(Oritech.ENERGY_CONTENT.componentType(), 0L);
    protected static final class_1792.class_1793 JETPACK_SETTINGS = UNBREAKING_SETTINGS; // .component(ComponentContent.STORED_FLUID.get(), FluidStack.create(FluidContent.STILL_FUEL.get().getStill(), 0)); //.component(Oritech.ENERGY_CONTENT.componentType(), 0L);
    
    public static final class_6880<class_1741> EXOSUIT_MATERIAL = class_1740.field_7892;
    public static final class_6880<class_1741> JETPACK_MATERIAL = class_1740.field_7897;
    public static final class_1832 ELECTRIC_MATERIAL = new ElectricToolMaterial();
    public static final class_1832 PROMETHIUM_MATERIAL = new PromethiumToolMaterial();
    
    public static final class_1792 EXO_HELMET = new ExoArmorItem(EXOSUIT_MATERIAL, class_1738.class_8051.field_41934, UNBREAKING_SETTINGS);
    public static final class_1792 EXO_CHESTPLATE = new BackstorageExoArmorItem(EXOSUIT_MATERIAL, class_1738.class_8051.field_41935, ELECTRIC_SETTINGS);
    public static final class_1792 EXO_LEGGINGS = new ExoArmorItem(EXOSUIT_MATERIAL, class_1738.class_8051.field_41936, UNBREAKING_SETTINGS);
    public static final class_1792 EXO_BOOTS = new ExoArmorItem(EXOSUIT_MATERIAL, class_1738.class_8051.field_41937, UNBREAKING_SETTINGS);
    
    public static final class_1792 JETPACK = new JetpackItem(JETPACK_MATERIAL, class_1738.class_8051.field_41935, JETPACK_SETTINGS);
    public static final class_1792 EXO_JETPACK = new JetpackExoArmorItem(EXOSUIT_MATERIAL, class_1738.class_8051.field_41935, JETPACK_SETTINGS);
    public static final class_1792 JETPACK_ELYTRA = new JetpackElytraItem(JETPACK_MATERIAL, class_1738.class_8051.field_41935, JETPACK_SETTINGS);
    public static final class_1792 JETPACK_EXO_ELYTRA = new JetpackExoElytraItem(EXOSUIT_MATERIAL, class_1738.class_8051.field_41935, JETPACK_SETTINGS);
    
    public static final class_1792 PORTABLE_LASER = new PortableLaserItem(UNBREAKING_SETTINGS);
    public static final class_1792 ELECTRIC_MACE = new ElectricMaceItem(UNBREAKING_SETTINGS.method_57348(ElectricMaceItem.method_59532()).method_7894(class_1814.field_8904));
    
    public static final class_1792 CHAINSAW = new ChainsawItem(ELECTRIC_MATERIAL, ELECTRIC_SETTINGS.method_57348(class_1743.method_57346(ELECTRIC_MATERIAL, 5f, -2.4f)));
    public static final class_1792 HAND_DRILL = new DrillItem(ELECTRIC_MATERIAL, TagContent.DRILL_MINEABLE, ELECTRIC_SETTINGS.method_57348(class_1810.method_57346(ELECTRIC_MATERIAL, 1f, -2.4f)));
    
    public static final class_1792 PROMETHIUM_AXE = new PromethiumAxeItem(PROMETHIUM_MATERIAL, UNBREAKING_SETTINGS.method_57348(class_1743.method_57346(PROMETHIUM_MATERIAL, 12f, -2.1f)));
    public static final class_1792 PROMETHIUM_PICKAXE = new PromethiumPickaxeItem(PROMETHIUM_MATERIAL, TagContent.DRILL_MINEABLE, UNBREAKING_SETTINGS.method_57348(class_1743.method_57346(PROMETHIUM_MATERIAL, 3f, -2.4f)));
    
    @Override
    public class_5321<class_2378<class_1792>> getRegistryType() {
        return class_7924.field_41197;
    }
    
    @Override
    public void postProcessField(String namespace, class_1792 value, String identifier, Field field, RegistrySupplier<class_1792> supplier) {
        
        var targetGroup = ItemContent.Groups.equipment;
        if (field.isAnnotationPresent(ItemContent.ItemGroupTarget.class)) {
            targetGroup = field.getAnnotation(ItemContent.ItemGroupTarget.class).value();
        }
        
        ItemGroups.add(targetGroup, value);
        
        if (EnergyApi.ITEM != null && value instanceof OritechEnergyItem energyItem) {
            var variantStack = new class_1799(value);
            variantStack.method_57379(EnergyApi.ITEM.getEnergyComponent(), energyItem.getEnergyCapacity(variantStack));
            ItemGroups.add(targetGroup, variantStack);
            
            EnergyApi.ITEM.registerForItem(() -> value);
        }
        
        if (FluidApi.ITEM != null && value instanceof FluidApi.ItemProvider) {
            FluidApi.ITEM.registerForItem(() -> value);
        }
        
    }
    
    public static void registerEventHandlers() {
        
        BlockEvent.BREAK.register(PromethiumPickaxeItem::preMine);
        // PlayerBlockBreakEvents.BEFORE.register(PromethiumPickaxeItem::preMine);
        
        TickEvent.SERVER_LEVEL_PRE.register(PromethiumAxeItem::onTick);
        
        EntityEvent.LIVING_HURT.register((entity, source, amount) -> {
            
            if (source.method_48793().method_40225(class_8111.field_42345) && entity instanceof class_1657 player) {
                var boots = player.method_6118(class_1304.field_6166);
                
                if (boots == null) return EventResult.pass();
                if (!(boots.method_7909() instanceof ExoArmorItem)) return EventResult.pass();
                
                player.method_37908().method_8396(null, player.method_24515(), SoundContent.SHORT_SERVO, class_3419.field_15248, 0.2f, 1.0f);
                
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        
    }
    
    @Override
    public Class<class_1792> getTargetFieldType() {
        return class_1792.class;
    }
}
