/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.recipe.ZetaDyeRecipe;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class DyeablesRegistry {
    public final Map<Item, BooleanSupplier> dyeableConditions = new HashMap<Item, BooleanSupplier>();

    @LoadEvent
    public void register(ZRegister event) {
        ResourceLocation id = event.getRegistry().newResourceLocation("dye_item");
        ZetaDyeRecipe recipe = new ZetaDyeRecipe(CraftingBookCategory.EQUIPMENT, this);
        event.getRegistry().register(recipe.getSerializer(), id, Registries.RECIPE_SERIALIZER);
    }

    @LoadEvent
    public void registerPost(ZRegister.Post event) {
        WashingInteraction wosh = new WashingInteraction();
        for (Item item : this.dyeableConditions.keySet()) {
            CauldronInteraction.WATER.map().put(item, wosh);
        }
    }

    public void register(Item item) {
        this.register(item, BooleanSuppliers.TRUE);
    }

    public void register(Item item, ZetaModule module) {
        this.register(item, module::isEnabled);
    }

    public void register(Item item, BooleanSupplier cond) {
        this.dyeableConditions.put(item, cond);
    }

    public boolean isDyeable(ItemStack stack) {
        Item item = stack.getItem();
        return this.dyeableConditions.containsKey(item) && this.dyeableConditions.get(item).getAsBoolean();
    }

    public boolean isDyed(ItemStack stack) {
        return this.isDyeable(stack) && stack.getComponents().has(DataComponents.DYED_COLOR);
    }

    public DyedItemColor getDye(ItemStack stack) {
        return (DyedItemColor)stack.getComponents().get(DataComponents.DYED_COLOR);
    }

    public void applyDye(ItemStack stack, DyedItemColor color) {
        if (this.isDyeable(stack)) {
            stack.update(DataComponents.DYED_COLOR, (Object)color, dyedItemColor -> dyedItemColor);
        }
    }

    public DyedItemColor getColor(ItemStack stack) {
        return this.isDyed(stack) ? (DyedItemColor)stack.getComponents().get(DataComponents.DYED_COLOR) : new DyedItemColor(0xFFFFFF, false);
    }

    public ItemStack dyeItem(ItemStack stack, List<DyeItem> dyes) {
        if (!this.isDyeable(stack)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = stack.copyWithCount(1);
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int i1 = 0;
        DyedItemColor dyeditemcolor = (DyedItemColor)itemstack.get(DataComponents.DYED_COLOR);
        if (dyeditemcolor != null) {
            int j1 = FastColor.ARGB32.red((int)dyeditemcolor.rgb());
            int k1 = FastColor.ARGB32.green((int)dyeditemcolor.rgb());
            int l1 = FastColor.ARGB32.blue((int)dyeditemcolor.rgb());
            l += Math.max(j1, Math.max(k1, l1));
            i += j1;
            j += k1;
            k += l1;
            ++i1;
        }
        for (DyeItem dyeitem : dyes) {
            int j3 = dyeitem.getDyeColor().getTextureDiffuseColor();
            int i2 = FastColor.ARGB32.red((int)j3);
            int j2 = FastColor.ARGB32.green((int)j3);
            int k2 = FastColor.ARGB32.blue((int)j3);
            l += Math.max(i2, Math.max(j2, k2));
            i += i2;
            j += j2;
            k += k2;
            ++i1;
        }
        int l2 = i / i1;
        int i3 = j / i1;
        int k3 = k / i1;
        float f = (float)l / (float)i1;
        float f1 = Math.max(l2, Math.max(i3, k3));
        l2 = (int)((float)l2 * f / f1);
        i3 = (int)((float)i3 * f / f1);
        k3 = (int)((float)k3 * f / f1);
        int l3 = FastColor.ARGB32.color((int)0, (int)l2, (int)i3, (int)k3);
        boolean flag = dyeditemcolor == null || dyeditemcolor.showInTooltip();
        itemstack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(l3, flag));
        return itemstack;
    }

    class WashingInteraction
    implements CauldronInteraction {
        WashingInteraction() {
        }

        @NotNull
        public ItemInteractionResult interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
            if (!DyeablesRegistry.this.isDyed(stack)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                stack.remove(DataComponents.DYED_COLOR);
                player.awardStat(Stats.CLEAN_ARMOR);
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
    }
}

