/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.module;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.mod.ZetaMod;

public class ZetaCategory {
    public final String name;
    public final Supplier<ItemStack> icon;
    @Nullable
    public final String requiredMod;
    private final boolean isRequiredModLoaded;

    public ZetaCategory(String name, Supplier<ItemStack> icon, @Nullable String requiredMod) {
        this.name = name;
        this.icon = icon;
        this.requiredMod = requiredMod;
        this.isRequiredModLoaded = requiredMod == null || ZetaMod.ZETA.isModLoaded(requiredMod);
    }

    public ZetaCategory(String name, Item icon, @Nullable String requiredMod) {
        this(name, () -> new ItemStack((ItemLike)icon), requiredMod);
    }

    public ZetaCategory(String name, Item icon) {
        this(name, icon, null);
    }

    public static ZetaCategory unknownCategory(String id) {
        return new ZetaCategory(id, () -> new ItemStack((ItemLike)Items.PAPER), null);
    }

    public boolean isAddon() {
        return this.requiredMod != null;
    }

    public boolean requiredModsLoaded() {
        return this.isRequiredModLoaded;
    }

    public String toString() {
        return "ZetaCategory{" + this.name + "}";
    }

    public Component getDisabledTooltip() {
        return Component.translatable((String)"zeta.misc.mod_disabled", (Object[])new Object[]{this.requiredMod}).withStyle(ChatFormatting.GRAY);
    }
}

