/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.violetmoon.zeta.registry.DyeablesRegistry;

public class ZetaDyeRecipe
extends CustomRecipe {
    protected final DyeablesRegistry dyeablesRegistry;
    protected final RecipeSerializer<?> serializer;

    public ZetaDyeRecipe(CraftingBookCategory cat, DyeablesRegistry dyeablesRegistry) {
        super(cat);
        this.dyeablesRegistry = dyeablesRegistry;
        this.serializer = new SimpleCraftingRecipeSerializer(cat_ -> new ZetaDyeRecipe(cat_, dyeablesRegistry, this::getSerializer));
    }

    protected ZetaDyeRecipe(CraftingBookCategory cat, DyeablesRegistry dyeablesRegistry, Supplier<RecipeSerializer<?>> loopCloser) {
        super(cat);
        this.dyeablesRegistry = dyeablesRegistry;
        this.serializer = loopCloser.get();
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack1 = craftingInput.getItem(i);
            if (itemstack1.isEmpty()) continue;
            if (this.dyeablesRegistry.isDyeable(itemstack1)) {
                if (!itemstack.isEmpty()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (!(itemstack1.getItem() instanceof DyeItem)) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.isEmpty() && !list.isEmpty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider pissing) {
        ArrayList list = Lists.newArrayList();
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemstack1 = input.getItem(i);
            if (itemstack1.isEmpty()) continue;
            Item item = itemstack1.getItem();
            if (this.dyeablesRegistry.isDyeable(itemstack1)) {
                if (!itemstack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                itemstack = itemstack1.copy();
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return ItemStack.EMPTY;
            }
            list.add((DyeItem)item);
        }
        return !itemstack.isEmpty() && !list.isEmpty() ? this.dyeablesRegistry.dyeItem(itemstack, list) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }
}

