/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.screen.SectionScreen;
import org.violetmoon.zeta.client.config.screen.ZetaScreen;
import org.violetmoon.zeta.client.config.widget.CategoryButton;
import org.violetmoon.zeta.client.config.widget.CheckboxButton;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;
import org.violetmoon.zeta.module.ZetaCategory;

public class ZetaConfigHomeScreen
extends ZetaScreen {
    protected final ChangeSet changeSet;
    protected Button saveButton;

    public ZetaConfigHomeScreen(ZetaClient zc, Screen parent) {
        super(zc, parent);
        this.changeSet = new ChangeSet(this.z.configInternals);
    }

    protected void init() {
        int i;
        super.init();
        List<ZetaCategory> categories = this.z.modules.getInhabitedCategories();
        @Nullable SectionDefinition generalSection = this.z.configManager.getGeneralSection();
        int buttonCount = categories.size();
        if (generalSection != null) {
            ++buttonCount;
        }
        int perLine = 3;
        ArrayList<Integer> categoryButtonXPositions = new ArrayList<Integer>(buttonCount);
        for (i = 0; i < buttonCount; i += 3) {
            categoryButtonXPositions.addAll(this.centeredRow(this.width / 2, 120, 10, Math.min(buttonCount - i, 3)));
        }
        for (i = 0; i < buttonCount; ++i) {
            int row = i / 3;
            int x = (Integer)categoryButtonXPositions.get(i);
            int y = 70 + row * 23;
            int bWidth = 120;
            if (i < categories.size()) {
                boolean active;
                ZetaCategory category = categories.get(i);
                ValueDefinition<Boolean> categoryEnabled = this.z.configManager.getCategoryEnabledOption(category);
                SectionDefinition categorySection = this.z.configManager.getCategorySection(category);
                Button mainButton = (Button)this.addRenderableWidget((GuiEventListener)new CategoryButton(x, y, bWidth -= 20, 20, this.componentFor(categorySection), category.icon.get(), b -> Minecraft.getInstance().setScreen((Screen)new SectionScreen(this.zc, this, this.changeSet, categorySection))));
                Button checkButton = (Button)this.addRenderableWidget((GuiEventListener)new CheckboxButton(this.zc, x + bWidth, y, this.changeSet, categoryEnabled));
                mainButton.active = active = category.requiredModsLoaded();
                checkButton.active = active;
                continue;
            }
            assert (generalSection != null);
            this.addRenderableWidget((GuiEventListener)new Button.Builder(this.componentFor(generalSection), b -> Minecraft.getInstance().setScreen((Screen)new SectionScreen(this.zc, this, this.changeSet, generalSection))).size(bWidth, 20).pos(x, y).build());
        }
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder(this.componentForSaveButton(), this::commit).size(200, 20).pos(this.width / 2 - 100, this.height - 30).build());
    }

    public List<Integer> centeredRow(int centerX, int buttonWidth, int hpad, int count) {
        int slop = (count % 2 == 0 ? hpad : buttonWidth) / 2;
        int fullButtonsLeftOfCenter = count / 2;
        int fullPaddingsLeftOfCenter = Math.max(0, (count - 1) / 2);
        int startX = centerX - slop - fullButtonsLeftOfCenter * buttonWidth - fullPaddingsLeftOfCenter * hpad;
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        int x = startX;
        for (int i = 0; i < count; ++i) {
            result.add(x);
            x += buttonWidth + hpad;
        }
        return result;
    }

    private Component componentFor(SectionDefinition section) {
        MutableComponent comp = Component.translatable((String)(this.z.modid + ".category." + section.name));
        if (this.changeSet.isDirty(section)) {
            comp.append((Component)Component.literal((String)"*").withStyle(ChatFormatting.GOLD));
        }
        return comp;
    }

    private Component componentForSaveButton() {
        MutableComponent comp = Component.translatable((String)"zeta.gui.config.save");
        int changeCount = this.changeSet.changeCount();
        if (changeCount > 0) {
            comp.append(" (").append((Component)Component.literal((String)String.valueOf(changeCount)).withStyle(ChatFormatting.GOLD)).append(")");
        }
        return comp;
    }

    public void commit(Button button) {
        this.changeSet.applyAllChanges();
        this.onClose();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, String.valueOf(ChatFormatting.BOLD) + I18n.get((String)"zeta.gui.config.header", (Object[])new Object[]{WordUtils.capitalizeFully((String)this.z.modid)}), this.width / 2, 15, 4775356);
    }

    public void tick() {
        super.tick();
        this.saveButton.setMessage(this.componentForSaveButton());
    }
}

