/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.registry;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.violetmoon.zeta.registry.ZetaRegistry;
import org.violetmoon.zetaimplforge.ForgeZeta;

public class ForgeZetaRegistry
extends ZetaRegistry {
    public ForgeZetaRegistry(ForgeZeta z) {
        super(z);
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(this::onRegisterEvent);
    }

    @SubscribeEvent
    private void onRegisterEvent(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        ResourceLocation registryRes = key.location();
        ResourceKey keyGeneric = ResourceKey.createRegistryKey((ResourceLocation)registryRes);
        Collection<Supplier<Object>> ourEntries = this.getDefers(registryRes);
        if (ourEntries != null && !ourEntries.isEmpty()) {
            for (Supplier<Object> supplier : ourEntries) {
                Object entry = supplier.get();
                ResourceLocation name = (ResourceLocation)this.internalNames.get(entry);
                this.z.log.debug("Registering to {} - {}", (Object)registryRes, (Object)name);
                event.register(keyGeneric, e -> e.register(name, entry));
            }
            this.clearDeferCache(registryRes);
        }
    }
}

