/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.advancement.MutableAdvancement;
import org.violetmoon.zeta.api.IAdvancementModifier;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZAddReloadListener;

public class AdvancementModifierRegistry {
    protected final Zeta zeta;
    protected final Multimap<ResourceLocation, IAdvancementModifier> modifiers = HashMultimap.create();
    protected boolean gatheredAddons = false;

    public AdvancementModifierRegistry(Zeta zeta) {
        this.zeta = zeta;
    }

    public ManualTrigger registerManualTrigger(String resloc) {
        ResourceLocation id = this.zeta.registry.newResourceLocation(resloc);
        ManualTrigger trigger = new ManualTrigger(id);
        CriteriaTriggers.register((String)id.toString(), (CriterionTrigger)trigger);
        return trigger;
    }

    public void addModifier(IAdvancementModifier mod) {
        for (ResourceLocation r : mod.getTargets()) {
            this.modifiers.put((Object)r, (Object)mod);
        }
    }

    @PlayEvent
    public void addListeners(ZAddReloadListener event) {
        if (!this.gatheredAddons) {
            this.gatheredAddons = true;
        }
        ServerAdvancementManager advancements = event.getServerResources().getAdvancements();
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)mgr -> this.onAdvancementsLoaded(advancements, event.getRegistryAccess())));
    }

    private void onAdvancementsLoaded(ServerAdvancementManager manager, RegistryAccess registry) {
        for (ResourceLocation res : this.modifiers.keySet()) {
            Collection found;
            AdvancementHolder advHolder = manager.get(res);
            if (advHolder == null || (found = this.modifiers.get((Object)res)).isEmpty()) continue;
            int modifications = 0;
            MutableAdvancement mutable = new MutableAdvancement(advHolder.value());
            for (IAdvancementModifier mod : found) {
                if (!mod.isActive() || !mod.apply(res, mutable, registry)) continue;
                ++modifications;
            }
            if (modifications <= 0) continue;
            this.zeta.log.info("Modified advancement {} with {} patches", (Object)advHolder.id(), (Object)modifications);
            mutable.commit();
        }
    }
}

