/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.ConfigManager;
import org.violetmoon.zeta.mod.ZetaMod;

public record FlagCondition(String flag, Optional<Boolean> extraCondition) implements ICondition
{
    public static final MapCodec<FlagCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("flag").forGetter(FlagCondition::flag), (App)Codec.BOOL.optionalFieldOf("extraCondition").forGetter(flagCondition -> flagCondition.extraCondition)).apply((Applicative)inst, FlagCondition::new));

    public static void doEventReal(RegisterEvent event) {
        if (event.getRegistry().equals((Object)NeoForgeRegistries.CONDITION_SERIALIZERS)) {
            Registry.register((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ZetaMod.ZETA.modid, (String)"flag"), CODEC);
        }
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public boolean test(ICondition.IContext context) {
        if (this.flag.contains("%")) {
            throw new RuntimeException("Illegal flag: " + this.flag);
        }
        Set<ConfigManager> iHateThis = ConfigManager.EVIL_CONFIG_STORAGE_THAT_I_NEED;
        Iterator<ConfigManager> iterator = iHateThis.iterator();
        while (iterator.hasNext()) {
            ConfigManager configManager = iterator.next();
            ConfigFlagManager cfm = configManager.getConfigFlagManager();
            if (!cfm.isValidFlag(this.flag)) {
                if (iterator.hasNext()) continue;
                cfm.zeta.log.warn("Non-existent flag {} being used", (Object)this.flag);
                return true;
            }
            boolean cond = true;
            if (this.extraCondition().isPresent()) {
                cond = this.extraCondition.get();
            }
            return cond && cfm.getFlag(this.flag);
        }
        return true;
    }
}

