/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.module;

import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.commons.lang3.text.WordUtils;
import org.violetmoon.zeta.module.ZetaCategory;
import org.violetmoon.zeta.module.ZetaLoadModuleAnnotationData;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ZetaSide;

public record TentativeModule(Class<? extends ZetaModule> clazz, Class<? extends ZetaModule> keyClass, ZetaCategory category, String displayName, String lowercaseName, String description, SortedSet<String> antiOverlap, boolean enabledByDefault, boolean clientReplacement, int loadPhase) {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TentativeModule from(ZetaLoadModuleAnnotationData data, Function<String, ZetaCategory> categoryResolver) {
        Class<?> clazzUnchecked = data.clazz();
        if (!ZetaModule.class.isAssignableFrom(clazzUnchecked)) {
            throw new RuntimeException("Class " + clazzUnchecked.getName() + " does not extend ZetaModule");
        }
        Class<?> clazz = clazzUnchecked;
        String displayName = data.name().isEmpty() ? WordUtils.capitalizeFully((String)clazz.getSimpleName().replaceAll("Module$", "").replaceAll("(?<=.)([A-Z])", " $1")) : data.name();
        String lowercaseName = displayName.toLowerCase(Locale.ROOT).replace(" ", "_");
        boolean clientReplacement = data.clientReplacement();
        if (clientReplacement) {
            Class<?> sup = clazz.getSuperclass();
            if (!ZetaModule.class.isAssignableFrom(sup) || ZetaModule.class == sup) throw new RuntimeException("Client extension module " + clazz.getName() + " should `extend` the module it's an extension of");
            keyClass = clazz.getSuperclass();
            return new TentativeModule(clazz, keyClass, categoryResolver.apply(data.category()), displayName, lowercaseName, data.description(), new TreeSet<String>(List.of(data.antiOverlap())), data.enabledByDefault(), clientReplacement, data.loadPhase());
        } else {
            keyClass = clazz;
            if (data.category() != null && !data.category().isEmpty()) return new TentativeModule(clazz, keyClass, categoryResolver.apply(data.category()), displayName, lowercaseName, data.description(), new TreeSet<String>(List.of(data.antiOverlap())), data.enabledByDefault(), clientReplacement, data.loadPhase());
            throw new RuntimeException("Module " + clazz.getName() + " should specify a category");
        }
    }

    public TentativeModule replaceWith(TentativeModule replacement) {
        return new TentativeModule(replacement.clazz, this.keyClass, this.category, this.displayName, this.lowercaseName, this.description, this.antiOverlap, this.enabledByDefault, false, replacement.loadPhase);
    }

    public boolean appliesTo(ZetaSide side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case ZetaSide.CLIENT -> true;
            case ZetaSide.SERVER -> !this.clientReplacement;
        };
    }
}

