/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.client.ZetaClient;

public class PencilButton
extends Button {
    private final ResourceLocation iconsTexture;

    public PencilButton(ResourceLocation iconsTexture, int x, int y, Button.OnPress pressable) {
        super(new Button.Builder((Component)Component.literal((String)""), pressable).size(20, 20).pos(x, y));
        this.iconsTexture = iconsTexture;
    }

    public PencilButton(ZetaClient zc, int x, int y, Button.OnPress pressable) {
        this(zc.generalIcons, x, y, pressable);
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int u = 32;
        int v = 0;
        guiGraphics.blit(this.iconsTexture, this.getX() + 2, this.getY() + 1, u, v, 16, 16);
    }
}

