/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.screen;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.definition.ClientDefinitionExt;
import org.violetmoon.zeta.client.config.screen.ZetaScreen;
import org.violetmoon.zeta.client.config.widget.DefaultDiscardDone;
import org.violetmoon.zeta.client.config.widget.ScrollableWidgetList;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.Definition;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class SectionScreen
extends ZetaScreen {
    protected final SectionDefinition section;
    protected final ChangeSet changes;
    protected final String breadcrumbs;
    protected DefaultDiscardDone defaultDiscardDone;
    protected ScrollableWidgetList<SectionScreen, Entry> list;

    public SectionScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition section) {
        super(zc, parent);
        this.section = section;
        this.changes = changes;
        this.breadcrumbs = "> " + String.join((CharSequence)" > ", section.path);
    }

    protected void init() {
        super.init();
        double previousScrollAmount = this.list == null ? 0.0 : this.list.getScrollAmount();
        this.defaultDiscardDone = new DefaultDiscardDone(this, this.changes, this.section);
        this.defaultDiscardDone.addWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.list = new ScrollableWidgetList(this);
        for (ValueDefinition<?> value : this.section.getValues()) {
            this.list.addEntry(new ValueDefinitionEntry(this, this.changes, value));
        }
        Collection<SectionDefinition> subsections = this.section.getSubsections();
        if (!subsections.isEmpty()) {
            this.list.addEntry(new Divider());
            for (SectionDefinition subsection : this.section.getSubsections()) {
                this.list.addEntry(new SectionDefinitionEntry(this, this.changes, subsection));
            }
        }
        this.list.addChildWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.list.setScrollAmount(previousScrollAmount);
        this.addWidget((GuiEventListener)this.list);
        this.defaultDiscardDone.discard.active = this.changes.isDirty(this.section);
    }

    public void tick() {
        this.defaultDiscardDone.discard.active = this.changes.isDirty(this.section);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.list.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.list.reenableVisibleWidgets();
        int left = 20;
        String modName = WordUtils.capitalizeFully((String)this.z.modid);
        guiGraphics.drawString(this.font, String.valueOf(ChatFormatting.BOLD) + I18n.get((String)"zeta.gui.config.header", (Object[])new Object[]{modName}), left, 10, 4775356);
        guiGraphics.drawString(this.font, this.breadcrumbs, left, 20, 0xFFFFFF);
    }

    public class ValueDefinitionEntry<X>
    extends DefinitionEntry<ValueDefinition<X>> {
        public ValueDefinitionEntry(SectionScreen this$0, ChangeSet changes, ValueDefinition<X> def) {
            super(this$0, changes, def);
        }
    }

    public class Divider
    extends Entry {
        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            assert (SectionScreen.this.minecraft != null);
            String s = I18n.get((String)"zeta.gui.config.subcategories", (Object[])new Object[0]);
            guiGraphics.drawString(((SectionScreen)SectionScreen.this).minecraft.font, s, (float)rowLeft + (float)(rowWidth / 2 - ((SectionScreen)SectionScreen.this).minecraft.font.width(s) / 2), (float)(rowTop + 7), 0x6666FF, true);
        }

        @NotNull
        public Component getNarration() {
            return Component.literal((String)"");
        }
    }

    public class SectionDefinitionEntry
    extends DefinitionEntry<SectionDefinition> {
        public SectionDefinitionEntry(SectionScreen this$0, ChangeSet changes, SectionDefinition def) {
            super(this$0, changes, (Definition)def);
        }
    }

    public static class DefinitionEntry<T extends Definition>
    extends Entry {
        private final ChangeSet changes;
        private final T def;
        private final ClientDefinitionExt<T> ext;
        final /* synthetic */ SectionScreen this$0;

        public DefinitionEntry(ChangeSet changes, T def) {
            this.this$0 = this$0;
            this.changes = changes;
            this.def = def;
            this.ext = this$0.zc.clientConfigManager.getExt(def);
            this.ext.addWidgets(this$0.zc, this$0, changes, def, this::addScrollingWidget);
        }

        public void renderBack(@NotNull GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            assert (this.this$0.minecraft != null);
            int left = rowLeft + 10;
            int top = rowTop + 4;
            int effIndex = index + 1;
            if (this.def instanceof SectionDefinition) {
                --effIndex;
            }
            Object name = ((Definition)this.def).getTranslatedDisplayName(x$0 -> I18n.get((String)x$0, (Object[])new Object[0]));
            if (this.changes.isDirty((Definition)this.def)) {
                name = (String)name + String.valueOf(ChatFormatting.GOLD) + "*";
            }
            int len = ((SectionScreen)this.this$0).minecraft.font.width((String)name);
            int maxLen = rowWidth - 85;
            Object originalName = null;
            if (len > maxLen) {
                originalName = name;
                while ((len = ((SectionScreen)this.this$0).minecraft.font.width((String)(name = ((String)name).substring(0, ((String)name).length() - 1)))) > maxLen) {
                }
                name = (String)name + "...";
            }
            List tooltip = ((Definition)this.def).getTranslatedComment(x$0 -> I18n.get((String)x$0, (Object[])new Object[0])).stream().map(Component::literal).collect(Collectors.toList());
            if (originalName != null) {
                if (tooltip.isEmpty()) {
                    tooltip.add(Component.literal((String)originalName));
                } else {
                    tooltip.add(0, Component.empty());
                    tooltip.add(0, Component.literal((String)originalName));
                }
            }
            if (!tooltip.isEmpty()) {
                int hoverLeft = left + ((SectionScreen)this.this$0).minecraft.font.width((String)name + " ");
                int hoverRight = hoverLeft + ((SectionScreen)this.this$0).minecraft.font.width("(?)");
                name = (String)name + String.valueOf(ChatFormatting.AQUA) + " (?)";
                if (mouseX >= hoverLeft && mouseX < hoverRight && mouseY >= top && mouseY < top + 10) {
                    guiGraphics.renderComponentTooltip(this.this$0.font, tooltip, mouseX, mouseY);
                }
            }
            guiGraphics.drawString(((SectionScreen)this.this$0).minecraft.font, (String)name, left, top, 0xFFFFFF, true);
            if (this.ext != null) {
                guiGraphics.drawString(((SectionScreen)this.this$0).minecraft.font, this.ext.getSubtitle(this.changes, this.def), left, top + 10, 0x999999, true);
            }
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(guiGraphics, index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, partialTicks);
        }

        @NotNull
        public Component getNarration() {
            return Component.literal((String)((Definition)this.def).getTranslatedDisplayName(x$0 -> I18n.get((String)x$0, (Object[])new Object[0])));
        }
    }

    public static abstract class Entry
    extends ScrollableWidgetList.Entry<Entry> {
    }
}

