/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.block.be.ZetaBlockEntity;

public abstract class SimpleInventoryBlockEntity
extends ZetaBlockEntity
implements WorldlyContainer {
    protected NonNullList<ItemStack> inventorySlots = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);

    public SimpleInventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void readSharedNBT(CompoundTag tag, HolderLookup.Provider provider) {
        if (!this.needsToSyncInventory()) {
            return;
        }
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventorySlots, (HolderLookup.Provider)provider);
    }

    @Override
    public void writeSharedNBT(CompoundTag tag, HolderLookup.Provider provider) {
        if (!this.needsToSyncInventory()) {
            return;
        }
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventorySlots, (HolderLookup.Provider)provider);
    }

    protected boolean needsToSyncInventory() {
        return true;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.inventorySlots.get(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        if (!((ItemStack)this.inventorySlots.get(i)).isEmpty()) {
            ItemStack stackAt;
            if (((ItemStack)this.inventorySlots.get(i)).getCount() <= j) {
                stackAt = (ItemStack)this.inventorySlots.get(i);
                this.inventorySlots.set(i, (Object)ItemStack.EMPTY);
            } else {
                stackAt = ((ItemStack)this.inventorySlots.get(i)).split(j);
                if (((ItemStack)this.inventorySlots.get(i)).getCount() == 0) {
                    this.inventorySlots.set(i, (Object)ItemStack.EMPTY);
                }
            }
            this.inventoryChanged(i);
            return stackAt;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        ItemStack stack = this.getItem(i);
        this.setItem(i, ItemStack.EMPTY);
        this.inventoryChanged(i);
        return stack;
    }

    public void setItem(int i, @NotNull ItemStack itemstack) {
        this.inventorySlots.set(i, (Object)itemstack);
        this.inventoryChanged(i);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean stillValid(@NotNull Player entityplayer) {
        return this.getLevel().getBlockEntity(this.getBlockPos()) == this && entityplayer.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int i, @NotNull ItemStack itemstack) {
        return true;
    }

    public abstract void startOpen(@NotNull Player var1);

    public abstract void stopOpen(@NotNull Player var1);

    public void clearContent() {
        this.inventorySlots = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public abstract void inventoryChanged(int var1);

    public boolean isAutomationEnabled() {
        return true;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return this.isAutomationEnabled();
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, Direction direction) {
        return this.isAutomationEnabled();
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        if (this.isAutomationEnabled()) {
            int[] slots = new int[this.getContainerSize()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        return new int[0];
    }
}

