/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CategoryButton
extends Button {
    private final ItemStack icon;
    private final Component text;

    public CategoryButton(int x, int y, int w, int h, Component text, ItemStack icon, Button.OnPress onClick) {
        super(new Button.Builder((Component)Component.literal((String)""), onClick).pos(x, y).size(w, h));
        this.icon = icon;
        this.text = text;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.active) {
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"zeta.gui.config.missingaddon")));
        }
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.renderFakeItem(this.icon, this.getX() + 5, this.getY() + 2);
        int iconPad = 10;
        guiGraphics.drawCenteredString(mc.font, this.text, this.getX() + this.width / 2 + iconPad, this.getY() + (this.height - 8) / 2, this.getFGColor());
    }
}

