/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.world;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import org.violetmoon.zeta.config.type.CostSensitiveEntitySpawnConfig;
import org.violetmoon.zeta.config.type.EntitySpawnConfig;
import org.violetmoon.zeta.world.EntitySpawnHandler;

public class ZetaSpawnModifier {
    public static void modifyBiome(Holder<Biome> biome, EntitySpawnHandler handler, ModifiableBiomeInfo.BiomeInfo.Builder biomeInfoBuilder) {
        MobSpawnSettingsBuilder builder = biomeInfoBuilder.getMobSpawnSettings();
        for (EntitySpawnHandler.TrackedSpawnConfig c : handler.trackedSpawnConfigs) {
            EntitySpawnConfig entitySpawnConfig;
            List l = builder.getSpawner(c.classification);
            if (!c.secondary) {
                l.removeIf(e -> e.type.equals(c.entityType));
            }
            if (c.config.isEnabled() && c.config.biomes.canSpawn(biome)) {
                l.add(c.getEntry());
            }
            if (!((entitySpawnConfig = c.config) instanceof CostSensitiveEntitySpawnConfig)) continue;
            CostSensitiveEntitySpawnConfig csc = (CostSensitiveEntitySpawnConfig)entitySpawnConfig;
            builder.addMobCharge(c.entityType, csc.spawnCost, csc.maxCost);
        }
    }
}

