/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.module.ZetaModule;

public class FuriousCocktailModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET_AP = ResourceLocation.withDefaultNamespace((String)"nether/all_potions");
    private static final ResourceLocation TARGET_AE = ResourceLocation.withDefaultNamespace((String)"nether/all_effects");
    final BooleanSupplier isPotion;
    final Set<Holder<MobEffect>> effects;

    public FuriousCocktailModifier(ZetaModule module, BooleanSupplier isPotion, Set<Holder<MobEffect>> effects) {
        super(module);
        this.isPotion = isPotion;
        this.effects = effects;
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET_AP, (Object)TARGET_AE);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv, RegistryAccess registry) {
        EffectsChangedTrigger.TriggerInstance ect;
        CriterionTriggerInstance criterionTriggerInstance;
        if (!this.isPotion.getAsBoolean() && res.equals((Object)TARGET_AP)) {
            return false;
        }
        Criterion<?> crit = adv.getCriterion("all_effects");
        if (crit != null && (criterionTriggerInstance = crit.triggerInstance()) instanceof EffectsChangedTrigger.TriggerInstance && (ect = (EffectsChangedTrigger.TriggerInstance)criterionTriggerInstance).effects().isPresent()) {
            HashMap<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate> replacementMobEffectsMap = new HashMap<Holder<MobEffect>, MobEffectsPredicate.MobEffectInstancePredicate>();
            replacementMobEffectsMap.putAll(((MobEffectsPredicate)ect.effects().get()).effectMap());
            for (Holder<MobEffect> e : this.effects) {
                replacementMobEffectsMap.put(e, new MobEffectsPredicate.MobEffectInstancePredicate());
            }
            MobEffectsPredicate replacementPredicate = new MobEffectsPredicate(replacementMobEffectsMap);
            Criterion replacementCrit = new Criterion(crit.trigger(), (CriterionTriggerInstance)new EffectsChangedTrigger.TriggerInstance(ect.player(), Optional.of(replacementPredicate), ect.source()));
            adv.replaceCriterion("all_effects", replacementCrit);
            return true;
        }
        return false;
    }
}

