/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.event.bus;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.event.bus.Cancellable;
import org.violetmoon.zeta.event.bus.ZetaEventBus;

public class StandaloneZetaEventBus<E>
extends ZetaEventBus<E> {
    private final Map<Class<? extends E>, Listeners> listenerMap = new HashMap<Class<? extends E>, Listeners>();

    public StandaloneZetaEventBus(Class<? extends Annotation> subscriberAnnotation, Class<E> eventRoot, @Nullable Logger logSpam, Zeta ofZeta) {
        super(subscriberAnnotation, eventRoot, logSpam, ofZeta);
    }

    @Override
    protected void subscribeMethod(Method m, Object receiver, Class<?> owningClazz) {
        this.getListenersFor(m).subscribe(receiver, owningClazz, m);
    }

    @Override
    protected void unsubscribeMethod(Method m, Object receiver, Class<?> owningClazz) {
        this.getListenersFor(m).unsubscribe(receiver, owningClazz, m);
    }

    @Override
    public <T extends E> T fire(@NotNull T event) {
        Listeners subs = this.listenerMap.get(event.getClass());
        if (subs != null) {
            if (this.logSpam != null) {
                this.logSpam.info("Dispatching {} to {} listener{}", (Object)this.logSpamSimpleName(event.getClass()), (Object)subs.size(), (Object)(subs.size() > 1 ? "s" : ""));
            }
            subs.doFire(event);
        }
        return event;
    }

    @Override
    public <T extends E> T fire(@NotNull T event, Class<? super T> firedAs) {
        Listeners subs = this.listenerMap.get(firedAs);
        if (subs != null) {
            if (this.logSpam != null) {
                this.logSpam.info("Dispatching {} (as {}) to {} listener{}", (Object)this.logSpamSimpleName(event.getClass()), (Object)this.logSpamSimpleName(firedAs), (Object)subs.size(), (Object)(subs.size() > 1 ? "s" : ""));
            }
            subs.doFire(event);
        }
        return event;
    }

    private String logSpamSimpleName(Class<?> clazz) {
        String[] split = clazz.getName().split("\\.");
        return split[split.length - 1];
    }

    private Listeners getListenersFor(Method method) {
        if (method.getParameterCount() != 1) {
            throw this.arityERR(method);
        }
        Class<?> eventType = method.getParameterTypes()[0];
        if (!this.eventRoot.isAssignableFrom(eventType)) {
            throw this.typeERR(method);
        }
        return this.listenerMap.computeIfAbsent(eventType, __ -> new Listeners());
    }

    private class Listeners {
        private final Map<Subscriber, MethodHandle> handles = new LinkedHashMap<Subscriber, MethodHandle>();

        private Listeners() {
        }

        void subscribe(@Nullable Object receiver, Class<?> owningClazz, Method method) {
            try {
                this.handles.computeIfAbsent(new Subscriber(receiver, owningClazz, method), Subscriber::unreflect);
            }
            catch (Exception e) {
                throw StandaloneZetaEventBus.this.unreflectERR(method, e);
            }
        }

        void unsubscribe(@Nullable Object receiver, Class<?> owningClazz, Method method) {
            this.handles.remove(new Subscriber(receiver, owningClazz, method));
        }

        int size() {
            return this.handles.size();
        }

        void doFire(E event) {
            try {
                if (event instanceof Cancellable) {
                    Cancellable cancellable = (Cancellable)event;
                    this.doFireCancellable(cancellable);
                } else {
                    this.doFireNonCancellable(event);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception while firing event " + event + ": ", e);
            }
        }

        void doFireCancellable(Cancellable event) throws Throwable {
            for (MethodHandle handle : this.handles.values()) {
                handle.invoke(event);
                if (!event.isCanceled()) continue;
                break;
            }
        }

        void doFireNonCancellable(E event) throws Throwable {
            for (MethodHandle handle : this.handles.values()) {
                handle.invoke(event);
            }
        }

        private record Subscriber(@Nullable Object receiver, Class<?> owningClazz, Method method) {
            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Subscriber that = (Subscriber)object;
                return this.receiver == that.receiver && Objects.equals(this.owningClazz, that.owningClazz) && Objects.equals(this.method, that.method);
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this.receiver) + this.owningClazz.hashCode() + this.method.hashCode();
            }

            MethodHandle unreflect() {
                MethodHandle handle;
                try {
                    handle = MethodHandles.publicLookup().unreflect(this.method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (this.receiver != null) {
                    handle = handle.bindTo(this.receiver);
                }
                return handle;
            }
        }
    }
}

