/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.IZetaConfigInternals;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;
import org.violetmoon.zeta.config.type.IConfigType;
import org.violetmoon.zeta.module.ZetaModule;

public class ConfigObjectMapper {
    public static List<Field> walkModuleFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (clazz != ZetaModule.class && clazz != Object.class) {
            Field[] fields = clazz.getDeclaredFields();
            list.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static Object getField(Object owner, Field field) {
        Object receiver = Modifier.isStatic(field.getModifiers()) ? null : owner;
        try {
            return field.get(receiver);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object owner, Field field, Object value) {
        Object receiver = Modifier.isStatic(field.getModifiers()) ? null : owner;
        try {
            field.set(receiver, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readInto(SectionDefinition.Builder sect, Object obj, List<Consumer<IZetaConfigInternals>> databindings, ConfigFlagManager cfm) {
        if (obj instanceof ZetaModule) {
            ZetaModule zm = (ZetaModule)obj;
            ConfigObjectMapper.readInto(sect, obj, zm, databindings, cfm);
        } else {
            ConfigObjectMapper.readInto(sect, obj, null, databindings, cfm);
        }
    }

    public static void readInto(SectionDefinition.Builder sect, Object obj, @Nullable ZetaModule enclosingModule, List<Consumer<IZetaConfigInternals>> databindings, ConfigFlagManager cfm) {
        Config.RootComment rootComment = obj.getClass().getAnnotation(Config.RootComment.class);
        if (rootComment != null) {
            sect.comment(List.of(rootComment.value().split("\n")));
        }
        for (Field field : ConfigObjectMapper.walkModuleFields(obj.getClass())) {
            Object defaultValue;
            Config config = field.getAnnotation(Config.class);
            if (config == null) continue;
            field.setAccessible(true);
            String displayName = config.name().isEmpty() ? WordUtils.capitalizeFully((String)field.getName().replaceAll("(?<=.)([A-Z])", " $1")) : config.name();
            Config.Min min = field.getDeclaredAnnotation(Config.Min.class);
            Config.Max max = field.getDeclaredAnnotation(Config.Max.class);
            ArrayList<Object> comment = new ArrayList<Object>(4);
            if (!config.description().isEmpty()) {
                comment.addAll(List.of(config.description().split("\n")));
            }
            if (min != null || max != null) {
                String minPart;
                NumberFormat format = DecimalFormat.getNumberInstance(Locale.ROOT);
                String string = min == null ? "(" : (minPart = (min.exclusive() ? "(" : "[") + format.format(min.value()));
                String maxPart = max == null ? ")" : format.format(max.value()) + (max.exclusive() ? ")" : "]");
                comment.add("Allowed values: " + minPart + "," + maxPart);
            }
            if ((defaultValue = ConfigObjectMapper.getField(obj, field)) == null) {
                throw new IllegalArgumentException("@Config fields can't have null default values - field " + field.getName() + " obj " + obj.getClass());
            }
            Config.Condition condition = field.getDeclaredAnnotation(Config.Condition.class);
            Predicate<Object> restriction = ConfigObjectMapper.restrict(min, max, condition);
            if (defaultValue instanceof IConfigType) {
                IConfigType configType = (IConfigType)defaultValue;
                sect.addSubsection(subsectionBuilder -> {
                    ((SectionDefinition.Builder)((SectionDefinition.Builder)((SectionDefinition.Builder)subsectionBuilder.name(displayName.toLowerCase(Locale.ROOT).replace(" ", "_"))).englishDisplayName(displayName)).comment(comment)).hint(configType);
                    ConfigObjectMapper.readInto(subsectionBuilder, configType, enclosingModule, databindings, cfm);
                });
                databindings.add(z -> configType.onReload(enclosingModule, cfm));
                continue;
            }
            ValueDefinition def = sect.addValue(defBuilder -> ((ValueDefinition.Builder)((ValueDefinition.Builder)((ValueDefinition.Builder)defBuilder.name(displayName)).englishDisplayName(displayName)).comment(comment)).defaultValue(defaultValue).validator(restriction));
            databindings.add(z -> ConfigObjectMapper.setField(obj, field, z.get(def)));
            String flag = config.flag();
            if (flag.isEmpty()) continue;
            if (enclosingModule == null) {
                throw new IllegalArgumentException("Only ZetaModules can have `@Config(flag = ...)` annotations.\nClass: " + obj.getClass() + "\nField: " + field);
            }
            ValueDefinition<Boolean> defBool = def.downcast(Boolean.class);
            if (defBool == null) {
                throw new IllegalArgumentException("Only boolean fields can be annotated with `@Config(flag = ...)`.\nClass: " + obj.getClass() + "\nField: " + field);
            }
            cfm.putFlag(enclosingModule, flag, true);
            databindings.add(z -> cfm.putFlag(enclosingModule, flag, (Boolean)z.get(defBool)));
        }
    }

    private static Predicate<Object> restrict(@Nullable Config.Min min, @Nullable Config.Max max, @Nullable Config.Condition condition) {
        double minVal = min == null ? -1.7976931348623157E308 : min.value();
        double maxVal = max == null ? Double.MAX_VALUE : max.value();
        boolean minExclusive = min != null && min.exclusive();
        boolean maxExclusive = max != null && max.exclusive();
        Predicate<Object> pred = o -> ConfigObjectMapper.restrict(o, minVal, minExclusive, maxVal, maxExclusive);
        if (condition != null) {
            try {
                Constructor<? extends Predicate<Object>> constr = condition.value().getDeclaredConstructor(new Class[0]);
                constr.setAccessible(true);
                Predicate<Object> additionalPredicate = constr.newInstance(new Object[0]);
                pred = pred.and(additionalPredicate);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse config Predicate annotation: ", e);
            }
        }
        return pred;
    }

    private static boolean restrict(Object o, double minVal, boolean minExclusive, double maxVal, boolean maxExclusive) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            Number num = (Number)o;
            double val = num.doubleValue();
            if (minExclusive ? minVal >= val : minVal > val) {
                return false;
            }
            if (maxExclusive ? maxVal <= val : maxVal < val) {
                return false;
            }
        }
        return true;
    }
}

