/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.world;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.util.zetalist.ZetaList;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zetaimplforge.world.ZetaSpawnModifier;

public class ZetaBiomeModifier
implements BiomeModifier {
    public static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"zeta", (String)"biome_modifier");
    private static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<? extends BiomeModifier>> SERIALIZER = DeferredHolder.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (ResourceLocation)RESOURCE);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            ZetaBiomeModifier.modifyBiome(biome, builder);
            for (Zeta zeta : ZetaList.INSTANCE.getZetas()) {
                ZetaSpawnModifier.modifyBiome(biome, zeta.entitySpawn, builder);
            }
        }
    }

    @NotNull
    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)SERIALIZER.get();
    }

    public static MapCodec<ZetaBiomeModifier> makeCodec() {
        return MapCodec.unit(ZetaBiomeModifier::new);
    }

    public static void modifyBiome(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder biomeInfoBuilder) {
        BiomeGenerationSettingsBuilder settings = biomeInfoBuilder.getGenerationSettings();
        for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
            List features = settings.getFeatures(stage);
            features.add(WorldGenHandler.defers.get(stage));
        }
    }

    public static void registerBiomeModifier(IEventBus bus) {
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"zeta");
        biomeModifiers.register(bus);
        biomeModifiers.register(RESOURCE.getPath(), ZetaBiomeModifier::makeCodec);
    }
}

