/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.screen.AbstractInputScreen;
import org.violetmoon.zeta.client.config.widget.ScrollableWidgetList;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.ValueDefinition;

public class StringListInputScreen
extends AbstractInputScreen<List<String>> {
    protected ScrollableWidgetList<StringListInputScreen, Entry> list;

    public StringListInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, ValueDefinition<List<String>> def) {
        super(zc, parent, changes, def);
    }

    @Override
    protected void init() {
        super.init();
        this.list = new ScrollableWidgetList(this);
        this.forceUpdateWidgetsTo((List)this.get());
    }

    @Override
    protected void forceUpdateWidgetsTo(List<String> value) {
        this.removeWidget((GuiEventListener)this.list);
        this.list.removeChildWidgets(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.list.replaceEntries(IntStream.range(0, value.size() + 1).mapToObj(x$0 -> new Entry(x$0)).toList());
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.list.addChildWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.updateButtonStatus(this.def.validate(value));
        this.addWidget((GuiEventListener)this.list);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.list.reenableVisibleWidgets();
        this.list.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)this.def.getTranslatedDisplayName(x$0 -> I18n.get((String)x$0, (Object[])new Object[0]))).withStyle(ChatFormatting.BOLD), this.width / 2, 20, 0xFFFFFF);
    }

    protected String getString(int index) {
        List list = (List)this.get();
        if (index < list.size()) {
            return (String)list.get(index);
        }
        return null;
    }

    protected void setString(int index, String s) {
        ArrayList<String> copy = new ArrayList<String>((Collection)this.get());
        copy.set(index, s);
        this.set(copy);
        this.updateButtonStatus(this.def.validate(copy));
    }

    protected void add() {
        ArrayList<String> copy = new ArrayList<String>((Collection)this.get());
        copy.add("");
        this.set(copy);
        this.forceUpdateWidgetsTo((List<String>)copy);
        this.updateButtonStatus(this.def.validate(copy));
        this.list.ensureVisible2(copy.size() + 1);
    }

    protected void remove(int idx) {
        ArrayList<String> copy = new ArrayList<String>((Collection)this.get());
        copy.remove(idx);
        this.set(copy);
        this.forceUpdateWidgetsTo((List<String>)copy);
        this.updateButtonStatus(this.def.validate(copy));
    }

    protected class Entry
    extends ScrollableWidgetList.Entry<Entry> {
        private final int index;

        public Entry(int index) {
            this.index = index;
            String here = StringListInputScreen.this.getString(index);
            if (StringListInputScreen.this.getString(index) != null) {
                Minecraft mc = Minecraft.getInstance();
                EditBox field = new EditBox(mc.font, 10, 3, 210, 20, (Component)Component.literal((String)""));
                field.setMaxLength(256);
                field.setValue(here);
                field.moveCursorTo(0, false);
                field.setResponder(str -> StringListInputScreen.this.setString(index, (String)str));
                this.addScrollingWidget((AbstractWidget)field);
                this.addScrollingWidget((AbstractWidget)new Button.Builder((Component)Component.literal((String)"-").withStyle(ChatFormatting.RED), b -> StringListInputScreen.this.remove(index)).size(20, 20).pos(230, 3).build());
            } else {
                this.addScrollingWidget((AbstractWidget)new Button.Builder((Component)Component.literal((String)"+").withStyle(ChatFormatting.GREEN), b -> StringListInputScreen.this.add()).size(20, 20).pos(10, 3).build());
            }
        }

        @NotNull
        public Component getNarration() {
            return Component.literal((String)Optional.ofNullable(StringListInputScreen.this.getString(this.index)).orElse(""));
        }
    }
}

