/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block;

import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.BooleanSuppliers;

public abstract class ZetaButtonBlock
extends ButtonBlock
implements IZetaBlock {
    @Nullable
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public ZetaButtonBlock(BlockSetType setType, int ticksToStayPressed, String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(setType, ticksToStayPressed, properties);
        this.module = module;
        if (module == null) {
            return;
        }
        module.zeta().registry.registerBlock((Block)this, regname, true);
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS, (ItemLike)this, (ItemLike)Blocks.STONE_BUTTON, false);
    }

    @NotNull
    protected abstract SoundEvent getSound(boolean var1);

    @Override
    public ZetaButtonBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }
}

