/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.ApiStatus;
import org.violetmoon.zeta.event.bus.IZetaPlayEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZAddReloadListener;
import org.violetmoon.zeta.event.load.ZTagsUpdated;
import org.violetmoon.zeta.event.play.ZRecipeCrawl;
import org.violetmoon.zeta.event.play.ZServerTick;
import org.violetmoon.zeta.mod.ZetaMod;

@ApiStatus.Internal
public class RecipeCrawlHandler {
    private static final List<Recipe<?>> vanillaRecipesToLazyDigest = new ArrayList();
    private static final Multimap<Item, ItemStack> vanillaRecipeDigestion = HashMultimap.create();
    private static final Multimap<Item, ItemStack> backwardsVanillaDigestion = HashMultimap.create();
    private static final Object mutex = new Object();
    private static boolean needsCrawl = false;
    private static boolean mayCrawl = false;

    @PlayEvent
    public static void addListener(ZAddReloadListener event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager mgr, ProfilerFiller prof) {
                RecipeCrawlHandler.clear();
                return null;
            }

            protected void apply(Void what, ResourceManager mgr, ProfilerFiller prof) {
                needsCrawl = true;
            }
        });
    }

    @PlayEvent
    public static void tagsHaveUpdated(ZTagsUpdated event) {
        mayCrawl = true;
    }

    private static void clear() {
        mayCrawl = false;
        RecipeCrawlHandler.fire(new ZRecipeCrawl.Reset());
    }

    private static void fire(IZetaPlayEvent event) {
        ZetaMod.ZETA.playBus.fire(event);
    }

    private static void load(RecipeManager manager, RegistryAccess access) {
        if (!manager.getRecipes().isEmpty()) {
            RecipeCrawlHandler.fire(new ZRecipeCrawl.Starting());
            vanillaRecipesToLazyDigest.clear();
            vanillaRecipeDigestion.clear();
            backwardsVanillaDigestion.clear();
            for (RecipeHolder recipeHolder : manager.getRecipes()) {
                try {
                    ZRecipeCrawl.Visit event;
                    Recipe recipe;
                    Recipe recipe2 = recipeHolder.value();
                    if (recipe2 == null) {
                        throw new IllegalStateException("Recipe is null");
                    }
                    if (recipe2.getIngredients() == null) {
                        throw new IllegalStateException("Recipe ingredients are null");
                    }
                    if (recipe2.getResultItem((HolderLookup.Provider)access) == null) {
                        throw new IllegalStateException("Recipe getResultItem is null");
                    }
                    boolean isMisc = false;
                    Objects.requireNonNull(recipe2);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedRecipe.class, ShapelessRecipe.class, CustomRecipe.class, AbstractCookingRecipe.class}, (Object)recipe, n)) {
                        case 0: {
                            ShapedRecipe sr = (ShapedRecipe)recipe;
                            event = new ZRecipeCrawl.Visit.Shaped((RecipeHolder<ShapedRecipe>)recipeHolder, access);
                            break;
                        }
                        case 1: {
                            ShapelessRecipe sr = (ShapelessRecipe)recipe;
                            event = new ZRecipeCrawl.Visit.Shapeless((RecipeHolder<ShapelessRecipe>)recipeHolder, access);
                            break;
                        }
                        case 2: {
                            CustomRecipe cr = (CustomRecipe)recipe;
                            event = new ZRecipeCrawl.Visit.Custom((RecipeHolder<CustomRecipe>)recipeHolder, access);
                            break;
                        }
                        case 3: {
                            AbstractCookingRecipe acr = (AbstractCookingRecipe)recipe;
                            event = new ZRecipeCrawl.Visit.Cooking((RecipeHolder<ShapelessRecipe>)recipeHolder, access);
                            break;
                        }
                        default: {
                            event = new ZRecipeCrawl.Visit.Misc((RecipeHolder<Recipe<?>>)recipeHolder, access);
                            isMisc = true;
                        }
                    }
                    if (!isMisc) {
                        vanillaRecipesToLazyDigest.add(recipe2);
                    }
                    RecipeCrawlHandler.fire(event);
                }
                catch (Exception e) {
                    if (recipeHolder == null) {
                        ZetaMod.LOGGER.error("Encountered null recipe in RecipeManager.getRecipes. This is not good");
                        continue;
                    }
                    ZetaMod.LOGGER.error("Failed to scan recipe {}. This should be reported to {}!", (Object)recipeHolder.id(), (Object)recipeHolder.id().getNamespace(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlayEvent
    public static void onTick(ZServerTick.Start tick) {
        Object object = mutex;
        synchronized (object) {
            if (mayCrawl && needsCrawl) {
                RecipeManager manager = tick.getServer().getRecipeManager();
                RegistryAccess.Frozen access = tick.getServer().registryAccess();
                RecipeCrawlHandler.load(manager, (RegistryAccess)access);
                needsCrawl = false;
            }
            if (!vanillaRecipesToLazyDigest.isEmpty()) {
                vanillaRecipeDigestion.clear();
                backwardsVanillaDigestion.clear();
                for (Recipe<?> recipe : vanillaRecipesToLazyDigest) {
                    RecipeCrawlHandler.digest(recipe, (RegistryAccess)tick.getServer().registryAccess());
                }
                vanillaRecipesToLazyDigest.clear();
                RecipeCrawlHandler.fire(new ZRecipeCrawl.Digest(vanillaRecipeDigestion, backwardsVanillaDigestion));
            }
        }
    }

    private static void digest(Recipe<?> recipe, RegistryAccess access) {
        ItemStack out = recipe.getResultItem((HolderLookup.Provider)access);
        Item outItem = out.getItem();
        NonNullList ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack inStack : ingredient.getItems()) {
                ItemStack remaining = inStack.getCraftingRemainingItem();
                if (remaining == null) {
                    ZetaMod.LOGGER.error("Item {} returned NULL from getCraftingRemainingItem. This is wrong and will cause problems down the line", (Object)inStack.getItem());
                    continue;
                }
                if (!remaining.isEmpty()) continue;
                vanillaRecipeDigestion.put((Object)inStack.getItem(), (Object)out);
                backwardsVanillaDigestion.put((Object)outItem, (Object)inStack);
            }
        }
    }
}

