/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.magnetsystem;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagnetMoveAction;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorBlockBehavior;

public class DefaultMoveActions {
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.randomUUID(), "[MagnetStonecutter]");

    public static void addActions(HashMap<Block, IMagnetMoveAction> map) {
        map.put(Blocks.STONECUTTER, DefaultMoveActions::stonecutterMoved);
        map.put(Blocks.HOPPER, DefaultMoveActions::hopperMoved);
    }

    private static void stonecutterMoved(Level world, BlockPos pos, Direction direction, BlockState state, BlockEntity tile) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos up = pos.above();
            BlockState breakState = world.getBlockState(up);
            double hardness = breakState.getDestroySpeed((BlockGetter)world, up);
            if (hardness > -1.0 && hardness < MagnetsModule.stoneCutterMaxHardness) {
                if (MagnetsModule.stoneCutterSilkTouch) {
                    DefaultMoveActions.destroyBlockWithSilkTouch(breakState, up, serverLevel, 512);
                } else {
                    world.destroyBlock(up, true);
                }
            }
        }
    }

    private static boolean destroyBlockWithSilkTouch(BlockState blockstate, BlockPos pPos, ServerLevel level, int pRecursionLeft) {
        if (blockstate.isAir()) {
            return false;
        }
        FluidState fluidstate = level.getFluidState(pPos);
        if (!(blockstate.getBlock() instanceof BaseFireBlock)) {
            level.levelEvent(2001, pPos, Block.getId((BlockState)blockstate));
        }
        FakePlayer player = FakePlayerFactory.get((ServerLevel)level, (GameProfile)FAKE_PLAYER_PROFILE);
        ItemStack tool = Items.IRON_PICKAXE.getDefaultInstance();
        tool.enchant((Holder)((Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolderOrThrow(Enchantments.SILK_TOUCH), 1);
        player.setItemInHand(InteractionHand.MAIN_HAND, tool);
        BlockEntity blockentity = blockstate.hasBlockEntity() ? level.getBlockEntity(pPos) : null;
        Block.dropResources((BlockState)blockstate, (Level)level, (BlockPos)pPos, (BlockEntity)blockentity, (Entity)player, (ItemStack)tool);
        boolean flag = level.setBlock(pPos, fluidstate.createLegacyBlock(), 3, pRecursionLeft);
        if (flag) {
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pPos, GameEvent.Context.of(null, (BlockState)blockstate));
        }
        return flag;
    }

    private static void hopperMoved(Level world, BlockPos pos, Direction direction, BlockState state, BlockEntity tile) {
        if (!world.isClientSide && tile instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)tile;
            hopper.setCooldown(0);
            Direction dir = (Direction)state.getValue((Property)HopperBlock.FACING);
            BlockPos offPos = pos.relative(dir);
            BlockPos targetPos = pos.relative(direction);
            if (offPos.equals((Object)targetPos)) {
                return;
            }
            if (world.isEmptyBlock(offPos)) {
                for (int i = 0; i < hopper.getContainerSize(); ++i) {
                    ItemStack stack = hopper.getItem(i);
                    if (stack.isEmpty()) continue;
                    ItemStack drop = stack.copy();
                    drop.setCount(1);
                    hopper.removeItem(i, 1);
                    boolean shouldDrop = true;
                    Item item = drop.getItem();
                    if (item instanceof BlockItem) {
                        BlockPos seedPos;
                        BlockItem blockItem = (BlockItem)item;
                        BlockPos groundPos = offPos.below();
                        if (world.isEmptyBlock(groundPos)) {
                            groundPos = groundPos.below();
                        }
                        Block seedType = blockItem.getBlock();
                        if ((blockItem instanceof SpecialPlantable || seedType instanceof BushBlock) && state.canSurvive((LevelReader)world, seedPos = groundPos.above())) {
                            BlockState seedState = seedType.defaultBlockState();
                            world.playSound(null, seedPos, ((AccessorBlockBehavior)seedType).invokeGetSoundType(seedState).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            boolean canPlace = true;
                            if (seedState.getBlock() instanceof DoublePlantBlock) {
                                canPlace = false;
                                BlockPos abovePos = seedPos.above();
                                if (world.isEmptyBlock(abovePos)) {
                                    world.setBlockAndUpdate(abovePos, (BlockState)seedState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
                                    canPlace = true;
                                }
                            }
                            if (canPlace) {
                                world.setBlockAndUpdate(seedPos, seedState);
                                shouldDrop = false;
                            }
                        }
                    }
                    if (shouldDrop) {
                        double x = (double)pos.getX() + 0.5 + (double)dir.getStepX() * 0.7;
                        double y = (double)pos.getY() + 0.15 + (double)dir.getStepY() * 0.4;
                        double z = (double)pos.getZ() + 0.5 + (double)dir.getStepZ() * 0.7;
                        ItemEntity entity = new ItemEntity(world, x, y, z, drop);
                        entity.setDeltaMovement(Vec3.ZERO);
                        world.addFreshEntity((Entity)entity);
                    }
                    return;
                }
            }
        }
    }
}

