/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.client.config;

import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.config.SocialButton;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.quark.base.handler.ContributorRewardHandler;
import org.violetmoon.zeta.client.config.screen.ZetaConfigHomeScreen;

public class QuarkConfigHomeScreen
extends ZetaConfigHomeScreen {
    private static final CubeMap CUBE_MAP = new CubeMap(Quark.asResource("textures/misc/panorama/panorama"));
    private static final PanoramaRenderer PANORAMA = new PanoramaRenderer(CUBE_MAP);
    private float time;

    public QuarkConfigHomeScreen(Screen parent) {
        super(QuarkClient.ZETA_CLIENT, parent);
    }

    protected void init() {
        super.init();
        List socialButtonPlacements = this.centeredRow(this.width / 2, 20, 5, 5);
        Iterator iter = socialButtonPlacements.iterator();
        this.addRenderableWidget((GuiEventListener)new SocialButton((int)((Integer)iter.next()), this.height - 55, (Component)Component.translatable((String)"quark.gui.config.social.website"), 4775356, 0, "https://quarkmod.net"));
        this.addRenderableWidget((GuiEventListener)new SocialButton((int)((Integer)iter.next()), this.height - 55, (Component)Component.translatable((String)"quark.gui.config.social.discord"), 7506394, 1, "https://discord.gg/vm"));
        this.addRenderableWidget((GuiEventListener)new SocialButton((int)((Integer)iter.next()), this.height - 55, (Component)Component.translatable((String)"quark.gui.config.social.patreon"), 16345172, 2, "https://patreon.com/vazkii"));
        this.addRenderableWidget((GuiEventListener)new SocialButton((int)((Integer)iter.next()), this.height - 55, (Component)Component.translatable((String)"quark.gui.config.social.forum"), 11948248, 3, "https://forum.violetmoon.org"));
        this.addRenderableWidget((GuiEventListener)new SocialButton((int)((Integer)iter.next()), this.height - 55, (Component)Component.translatable((String)"quark.gui.config.social.bluesky"), 1942002, 4, "https://bsky.app/profile/violetmoon.org"));
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.time += partialTick;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            float spin = 1.0f;
            float blur = 0.85f;
            if (this.time < 20.0f && !QuarkGeneralConfig.disableQMenuEffects) {
                spin += 20.0f - this.time;
                blur = this.time / 20.0f * 0.75f + 0.1f;
            }
            PANORAMA.render(graphics, this.width, this.height, blur, partialTick);
        } else {
            super.renderBackground(graphics, mouseX, mouseY, partialTick);
        }
        int boxWidth = 400;
        graphics.fill(this.width / 2 - boxWidth / 2, 0, this.width / 2 + boxWidth / 2, this.height, 0x66000000);
        graphics.fill(this.width / 2 - boxWidth / 2 - 1, 0, this.width / 2 - boxWidth / 2, this.height, 0x66999999);
        graphics.fill(this.width / 2 + boxWidth / 2, 0, this.width / 2 + boxWidth / 2 + 1, this.height, 0x66999999);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"quark.gui.config.subheader1", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, ContributorRewardHandler.featuredPatron, ChatFormatting.RESET}), this.width / 2, 28, 0x9EFFFE);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"quark.gui.config.subheader2", (Object[])new Object[0]), this.width / 2, 38, 0x9EFFFE);
    }
}

