/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.automation.block.EnderWatcherBlock;
import org.violetmoon.quark.content.automation.module.EnderWatcherModule;
import org.violetmoon.zeta.block.be.ZetaBlockEntity;

public class EnderWatcherBlockEntity
extends ZetaBlockEntity {
    public EnderWatcherBlockEntity(BlockPos pos, BlockState state) {
        super(EnderWatcherModule.blockEntityType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnderWatcherBlockEntity be) {
        boolean wasLooking = (Boolean)state.getValue((Property)EnderWatcherBlock.WATCHED);
        int currWatch = (Integer)state.getValue((Property)EnderWatcherBlock.POWER);
        int range = 80;
        int newWatch = 0;
        List players = level.getEntitiesOfClass(Player.class, new AABB(be.worldPosition.offset(-range, -range, -range).getCenter(), be.worldPosition.offset(range, range, range).getCenter()));
        EnderMan fakeEnderman = new EnderMan(EntityType.ENDERMAN, level);
        fakeEnderman.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5 - (double)fakeEnderman.getEyeHeight(), (double)pos.getZ() + 0.5);
        boolean looking = false;
        for (Player player : players) {
            double z;
            double y;
            HitResult result;
            ItemStack helm = player.getItemBySlot(EquipmentSlot.HEAD);
            fakeEnderman.lookAt((Entity)player, 180.0f, 180.0f);
            if (!helm.isEmpty() && Quark.ZETA.itemExtensions.get(helm).isEnderMaskZeta(helm, player, fakeEnderman) || (result = Quark.ZETA.raytracingUtil.rayTrace((Entity)player, level, (Entity)player, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, 64.0)) == null || result.getType() != HitResult.Type.BLOCK || !((BlockHitResult)result).getBlockPos().equals((Object)be.worldPosition)) continue;
            looking = true;
            Vec3 vec = result.getLocation();
            Direction dir = ((BlockHitResult)result).getDirection();
            double x = Math.abs(vec.x - (double)be.worldPosition.getX() - 0.5) * (double)(1 - Math.abs(dir.getStepX()));
            double fract = 1.0 - Math.sqrt(x * x + (y = Math.abs(vec.y - (double)be.worldPosition.getY() - 0.5) * (double)(1 - Math.abs(dir.getStepY()))) * y + (z = Math.abs(vec.z - (double)be.worldPosition.getZ() - 0.5) * (double)(1 - Math.abs(dir.getStepZ()))) * z) / 0.7071067811865476;
            int playerWatch = (int)Math.ceil(fract * 15.0);
            if (playerWatch == 15 && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                EnderWatcherModule.watcherCenterTrigger.trigger(sp);
            }
            newWatch = Math.max(newWatch, playerWatch);
        }
        if (!(level.isClientSide || looking == wasLooking && currWatch == newWatch)) {
            level.setBlock(be.worldPosition, (BlockState)((BlockState)level.getBlockState(be.worldPosition).setValue((Property)EnderWatcherBlock.WATCHED, (Comparable)Boolean.valueOf(looking))).setValue((Property)EnderWatcherBlock.POWER, (Comparable)Integer.valueOf(newWatch)), 3);
        }
        if (looking) {
            double x = (double)be.worldPosition.getX() - 0.1 + Math.random() * 1.2;
            double y = (double)be.worldPosition.getY() - 0.1 + Math.random() * 1.2;
            double z = (double)be.worldPosition.getZ() - 0.1 + Math.random() * 1.2;
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

